/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.step;

import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.execution.Step;

public class WaitStep
implements DeploymentStep {
    private static final int SECONDS_TO_SLEEP = 10;
    private int waitTimeInSeconds = 0;
    private int order;
    private String description;

    public WaitStep(int n, int n2, String string, String string2) {
        this.waitTimeInSeconds = n2;
        this.order = n;
        this.description = "Waiting " + this.waitTimeInSeconds + " seconds for " + string + " to " + string2;
    }

    public String getDescription() {
        return this.description;
    }

    public int getOrder() {
        return this.order;
    }

    public Step.Result execute(DeploymentExecutionContext deploymentExecutionContext) {
        int n = this.waitTimeInSeconds / 10;
        int n2 = this.waitTimeInSeconds % 10;
        deploymentExecutionContext.logOutput(this.description);
        try {
            int n3 = this.waitTimeInSeconds;
            for (int i = 1; i <= n; ++i) {
                deploymentExecutionContext.logOutput("Time remaining " + n3 + " seconds.");
                Thread.sleep(10000L);
                n3 -= 10;
            }
            if (n2 > 0) {
                deploymentExecutionContext.logOutput("Time remaining " + n2 + " seconds.");
                Thread.sleep(n2 * 1000);
            }
            deploymentExecutionContext.logOutput("Wait complete.");
        }
        catch (InterruptedException interruptedException) {
            deploymentExecutionContext.logOutput("Wait interupted.");
            Thread.currentThread().interrupt();
        }
        return Step.Result.Success;
    }
}

