/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.deployed;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionPlanningContext;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.deployit.plugin.generic.step.InspectScriptExecutionStep;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Metadata(description="Abstract deployed that can target any deployable to a generic container")
public abstract class AbstractDeployed<D extends Deployable>
extends BaseDeployed<D, HostContainer> {
    private Map<String, Object> freeMarkerContext = Collections.singletonMap("deployed", this);
    private DeployedApplication deployedApplication;
    private Operation planOperation;
    @Property(defaultValue="false", hidden=true, description="The generic container requires a restart for the action performed by this deployed.", required=false)
    private boolean restartRequired;
    @Property(defaultValue="false", hidden=true, description="The generic container requires a restart for the NOOP action performed by this deployed.", required=false)
    private boolean restartRequiredForNoop;
    @Property(hidden=true, defaultValue="50", description="The order of the step in the step list for the create operation.")
    private int createOrder;
    @Property(hidden=true, defaultValue="40", description="The order of the step in the step list for the destroy operation.")
    private int destroyOrder;
    @Property(hidden=true, defaultValue="50", description="The order of the step in the step list for the modify operation.")
    private int modifyOrder;
    @Property(hidden=true, defaultValue="50", description="The order of the step in the step list for the noop operation.")
    private int noopOrder;
    @Property(hidden=true, defaultValue="Create")
    private String createVerb;
    @Property(hidden=true, defaultValue="Modify")
    private String modifyVerb;
    @Property(hidden=true, defaultValue="Destroy")
    private String destroyVerb;
    @Property(hidden=true, defaultValue="Modify")
    private String noopVerb;
    @Property(required=false, hidden=true, description="Classpath to the script used to inspect the generic container.")
    private String inspectScript;
    @Property(hidden=true, required=false, description="Additional classpath resources that should be uploaded to the working directory before executing the inspect script.")
    private Set<String> inspectClasspathResources = Sets.newHashSet();
    @Property(hidden=true, required=false, description="Additional template classpath resources that should be uploaded to the working directory before executing the inspect script.The template is first rendered and the rendered content copied to a file, with the same name as the template, in the working directory.")
    private Set<String> inspectTemplateClasspathResources = Sets.newHashSet();

    public List<Step> controlTaskDispatch(String string) {
        String string2 = string + "Script";
        PropertyDescriptor propertyDescriptor = DescriptorRegistry.getDescriptor((Type)this.getType()).getPropertyDescriptor(string2);
        Preconditions.checkArgument((propertyDescriptor != null ? 1 : 0) != 0, (String)"Control task script property %s not defined for CI type %s", (Object[])new Object[]{string2, this.getType()});
        String string3 = this.resolveExpression((String)propertyDescriptor.get((ConfigurationItem)this));
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("container", this.getContainer());
        hashMap.put("deployed", this);
        return Collections.singletonList(new ScriptExecutionStep(1, string3, (HostContainer)this.getContainer(), hashMap, this.getDescription(string)));
    }

    @Inspect
    public void inspectContainer(InspectionPlanningContext inspectionPlanningContext) {
        if (Strings.emptyToNull((String)this.getInspectScript()) != null) {
            InspectScriptExecutionStep inspectScriptExecutionStep = new InspectScriptExecutionStep((ConfigurationItem)this, this.getInspectScript(), (HostContainer)this.getContainer(), this.freeMarkerContext, "Inspect " + (Object)((Object)this));
            inspectScriptExecutionStep.setTemplateClasspathResources(Lists.newArrayList(this.getInspectTemplateClasspathResources()));
            inspectScriptExecutionStep.setClasspathResources(Lists.newArrayList(this.getInspectClasspathResources()));
            inspectionPlanningContext.addStep((Step)inspectScriptExecutionStep);
        }
    }

    public boolean isRestartRequired() {
        return this.restartRequired;
    }

    public void setRestartRequired(boolean bl) {
        this.restartRequired = bl;
    }

    public int getCreateOrder() {
        return this.createOrder;
    }

    public void setCreateOrder(int n) {
        this.createOrder = n;
    }

    public int getDestroyOrder() {
        return this.destroyOrder;
    }

    public void setDestroyOrder(int n) {
        this.destroyOrder = n;
    }

    public int getModifyOrder() {
        return this.modifyOrder;
    }

    public void setModifyOrder(int n) {
        this.modifyOrder = n;
    }

    public String getCreateVerb() {
        return this.createVerb;
    }

    public void setCreateVerb(String string) {
        this.createVerb = string;
    }

    public String getModifyVerb() {
        return this.modifyVerb;
    }

    public void setModifyVerb(String string) {
        this.modifyVerb = string;
    }

    public String getDestroyVerb() {
        return this.destroyVerb;
    }

    public void setDestroyVerb(String string) {
        this.destroyVerb = string;
    }

    public int getNoopOrder() {
        return this.noopOrder;
    }

    public void setNoopOrder(int n) {
        this.noopOrder = n;
    }

    public String getNoopVerb() {
        return this.noopVerb;
    }

    public void setNoopVerb(String string) {
        this.noopVerb = string;
    }

    public boolean isRestartRequiredForNoop() {
        return this.restartRequiredForNoop;
    }

    public void setRestartRequiredForNoop(boolean bl) {
        this.restartRequiredForNoop = bl;
    }

    public String getDescription(String string) {
        return String.format("%s %s on %s", string, this.getDeployable().getName(), ((HostContainer)this.getContainer()).getName());
    }

    public Map<String, Object> getDeployedAsFreeMarkerContext() {
        return this.freeMarkerContext;
    }

    public Map<String, String> resolveExpression(Map<String, String> map) {
        return ConfigurationHolder.resolveExpression(map, this.getDeployedAsFreeMarkerContext());
    }

    public Set<String> resolveExpression(Set<String> set) {
        return ConfigurationHolder.resolveExpression(set, this.getDeployedAsFreeMarkerContext());
    }

    public String resolveExpression(String string) {
        return ConfigurationHolder.resolveExpression(string, this.getDeployedAsFreeMarkerContext());
    }

    public Object getPropertyOrContainerDefault(String string) {
        Preconditions.checkNotNull((Object)string, (Object)"Property must not be null.");
        Object object = this.getProperty(string, (ConfigurationItem)this);
        if (object == null) {
            object = this.getProperty(string, (ConfigurationItem)this.getContainer());
        }
        Preconditions.checkNotNull((Object)string, (String)"Property %s not found in %s or in %s.", (Object[])new Object[]{string, this.getType(), ((HostContainer)this.getContainer()).getType()});
        return object;
    }

    private Object getProperty(String string, ConfigurationItem configurationItem) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)configurationItem.getType());
        PropertyDescriptor propertyDescriptor = descriptor.getPropertyDescriptor(string);
        if (propertyDescriptor == null) {
            return null;
        }
        return propertyDescriptor.get(configurationItem);
    }

    public DeployedApplication getDeployedApplication() {
        return this.deployedApplication;
    }

    public void setDeployedApplication(DeployedApplication deployedApplication) {
        this.deployedApplication = deployedApplication;
    }

    public Operation getPlanOperation() {
        return this.planOperation;
    }

    public void setPlanOperation(Operation operation) {
        this.planOperation = operation;
    }

    public String getInspectScript() {
        return this.resolveExpression(this.inspectScript);
    }

    public void setInspectScript(String string) {
        this.inspectScript = string;
    }

    public Set<String> getInspectClasspathResources() {
        return this.resolveExpression(this.inspectClasspathResources);
    }

    public void setInspectClasspathResources(Set<String> set) {
        this.inspectClasspathResources = set;
    }

    public Set<String> getInspectTemplateClasspathResources() {
        return this.resolveExpression(this.inspectTemplateClasspathResources);
    }

    public void setInspectTemplateClasspathResources(Set<String> set) {
        this.inspectTemplateClasspathResources = set;
    }
}

