/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.f5;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.generic.ci.Container;
import com.xebialabs.deployit.plugin.generic.ci.NestedContainer;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class F5Contributor {
    @Contributor
    public void f5Activation(Deltas deltas, DeploymentPlanningContext deploymentPlanningContext) {
        Set<Container> set = this.gatherTargets(deltas.getDeltas());
        for (Container container : set) {
            String string = this.getProperty(container, "f5DisableStateScript");
            Preconditions.checkArgument((!Strings.nullToEmpty((String)string).trim().isEmpty() ? 1 : 0) != 0, (Object)"disable script must be specified.");
            this.addStep(string, this.getIntProperty(container, "f5DisableOrder"), container, "Disable", deploymentPlanningContext);
            if (!this.notUndeployment(deltas.getDeltas())) continue;
            String string2 = this.getProperty(container, "f5EnableStateScript");
            Preconditions.checkArgument((!Strings.nullToEmpty((String)string2).trim().isEmpty() ? 1 : 0) != 0, (Object)"enable script must be specified.");
            this.addStep(string2, this.getIntProperty(container, "f5EnableOrder"), container, "Enable", deploymentPlanningContext);
        }
    }

    private boolean notUndeployment(List<Delta> list) {
        for (Delta delta : list) {
            if (delta.getOperation() == Operation.DESTROY) continue;
            return true;
        }
        return false;
    }

    private String getProperty(Container container, String string) {
        if (this.hasProperty((ConfigurationItem)container, string)) {
            return (String)container.getProperty(string);
        }
        return "";
    }

    private int getIntProperty(Container container, String string) {
        if (this.hasProperty((ConfigurationItem)container, string)) {
            return (Integer)container.getProperty(string);
        }
        return 50;
    }

    private boolean hasProperty(ConfigurationItem configurationItem, String string) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)configurationItem.getType());
        Preconditions.checkArgument((descriptor != null ? 1 : 0) != 0, (String)"Type %s does not exist", (Object[])new Object[]{configurationItem.getType()});
        PropertyDescriptor propertyDescriptor = descriptor.getPropertyDescriptor(string);
        return propertyDescriptor != null;
    }

    private void addStep(String string, int n, Container container, String string2, DeploymentPlanningContext deploymentPlanningContext) {
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("container", container);
        deploymentPlanningContext.addStep((DeploymentStep)new ScriptExecutionStep(n, string, container, hashMap, this.getDescription(string2, container)));
    }

    private String getDescription(String string, Container container) {
        return String.format("%s F5 node for %s", string, container.getName());
    }

    private Set<Container> gatherTargets(List<Delta> list) {
        TreeSet treeSet = Sets.newTreeSet();
        for (Delta delta : list) {
            this.addTarget(treeSet, delta.getOperation(), delta.getDeployed());
            this.addTarget(treeSet, delta.getOperation(), delta.getPrevious());
        }
        return treeSet;
    }

    private void addTarget(Set<Container> set, Operation operation, Deployed<?, ?> deployed) {
        if (deployed == null) {
            return;
        }
        if (this.hasProperty((ConfigurationItem)deployed.getContainer(), "f5Enabled") && ((Boolean)deployed.getContainer().getProperty("f5Enabled")).booleanValue() && operation != Operation.NOOP) {
            set.add(this.getRootContainer((HostContainer)deployed.getContainer()));
        }
    }

    private Container getRootContainer(HostContainer hostContainer) {
        if (hostContainer instanceof Container) {
            return (Container)hostContainer;
        }
        if (hostContainer instanceof NestedContainer) {
            return ((NestedContainer)hostContainer).getRootContainer();
        }
        throw new IllegalStateException("The root container for a nested container not found. NestedContains should be rooted to a generic Container.");
    }
}

