/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.deployed;

import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.generic.deployed.AbstractDeployedArtifact;
import com.xebialabs.deployit.plugin.generic.step.ArtifactDeleteStep;
import com.xebialabs.deployit.plugin.generic.step.TemplateArtifactCopyStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;

@Metadata(virtual=true, description="A template deployed to a generic container")
public class ProcessedTemplate<D extends Deployable>
extends AbstractDeployedArtifact<D> {
    @Property(hidden=true, required=true, description="Classpath to the freemarker template used to generate the content of the final text base artifact.")
    private String template;

    @Create
    public void executeCreate(DeploymentPlanningContext ctx) {
        ctx.addStep((DeploymentStep)this.createTemplateArtifactCopyStep());
    }

    @Modify
    public void executeModify(DeploymentPlanningContext ctx, Delta d) {
        ProcessedTemplate previous = (ProcessedTemplate)d.getPrevious();
        previous.executeDestroy(ctx);
        this.executeCreate(ctx);
    }

    @Destroy
    public void executeDestroy(DeploymentPlanningContext ctx) {
        ctx.addStep((DeploymentStep)this.createArtifactDeleteStep());
    }

    protected TemplateArtifactCopyStep createTemplateArtifactCopyStep() {
        TemplateArtifactCopyStep step = new TemplateArtifactCopyStep(this.getCreateOrder(), (HostContainer)this.getContainer(), this.getDeployedAsFreeMarkerContext(), this.getTemplate(), this.getTargetDirectory());
        step.setCreateTargetPath(this.isCreateTargetDirectory());
        step.setTargetFileName(this.resolveTargetFileName());
        step.setSourceFileDescription(this.getDeployable().getName());
        step.setDescription(this.getDescription(this.getCreateVerb()));
        return step;
    }

    protected ArtifactDeleteStep createArtifactDeleteStep() {
        ArtifactDeleteStep step = new ArtifactDeleteStep(this.getDestroyOrder(), (HostContainer)this.getContainer(), this.getTargetDirectory());
        step.setTargetDirectoryShared(this.isTargetDirectoryShared());
        step.setTargetFile(this.resolveTargetFileName());
        step.setDescription(this.getDescription(this.getDestroyVerb()));
        return step;
    }

    public String getTemplate() {
        return this.resolveExpression(this.template);
    }

    public void setTemplate(String template) {
        this.template = template;
    }
}

