package com.xebialabs.deployit.plugin.generic.freemarker;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.generic.ci.Container;
import com.xebialabs.deployit.plugin.generic.ci.NestedContainer;
import com.xebialabs.deployit.plugin.generic.deployed.AbstractDeployed;
import com.xebialabs.overthere.OverthereFile;
import freemarker.ext.beans.BeanModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;

import java.util.Map;
import java.util.Set;

import static com.google.common.collect.Maps.newHashMap;
import static com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder.resolveExpression;

public class CiTemplateModel extends BeanModel {

    private static final String FILE_ATTRIBUTE = "file";

    private Descriptor descriptor;
    private ConfigurationItem ci;
    private CiAwareObjectWrapper wrapper;

    public CiTemplateModel(ConfigurationItem ci, CiAwareObjectWrapper wrapper) {
        super(ci, wrapper);
        this.ci = ci;
        this.wrapper = wrapper;
        descriptor = DescriptorRegistry.getDescriptor(ci.getType());
    }

    @Override
    public TemplateModel get(String key) throws TemplateModelException {
        if (key.equals(FILE_ATTRIBUTE)) {
            if (ci instanceof DeployableArtifact) {
                return handleDeployableArtifactFile();
            } else if (ci instanceof DerivedArtifact) {
                return handleDerivedArtifactFile();
            }
        }

        PropertyDescriptor pd = descriptor.getPropertyDescriptor(key);
        if (pd == null) {
            return super.get(key);
        } else {
            return wrapper.wrap(extractValueFromCi(pd));
        }
    }

    @SuppressWarnings("unchecked")
    private Object extractValueFromCi(PropertyDescriptor pd) {
        Map<String, Object> ctx = newHashMap();
        if (ci instanceof AbstractDeployed) {
            ctx.put("deployed", ci);
        } else if (ci instanceof Container || ci instanceof NestedContainer) {
            ctx.put("container", ci);
        }
        switch (pd.getKind()) {
            case STRING:
                return resolveExpression((String) pd.get(ci), ctx);
            case SET_OF_STRING:
                return resolveExpression((Set<String>) pd.get(ci), ctx);
            case MAP_STRING_STRING:
                return resolveExpression((Map<String, String>) pd.get(ci), ctx);
            default:
                return pd.get(ci);
        }
    }

    private TemplateModel handleDeployableArtifactFile() throws TemplateModelException {
       return uploadFile(((DeployableArtifact) ci).getFile());
    }

    private TemplateModel handleDerivedArtifactFile() throws TemplateModelException {
        return uploadFile(((DerivedArtifact<?>) ci).getFile());
    }

    private TemplateModel uploadFile(OverthereFile file) throws TemplateModelException {
        Object o = file;
        if (wrapper.getUploader() != null) {
            o = wrapper.getUploader().upload(file);
        }
        return wrapper.wrap(o);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}
