/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.step;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.generic.ci.Container;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.deployit.plugin.generic.step.ArtifactCopyStep;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import org.slf4j.MDC;

public class TemplateArtifactCopyStep
extends ArtifactCopyStep {
    private static final String MDC_KEY_TEMPLATE_PATH = "templatePath";
    private Map<String, Object> vars;
    private String templatePath;

    public TemplateArtifactCopyStep(int order, Container container, Map<String, Object> vars, String templatePath, String targetPath) {
        super(order, null, container, targetPath);
        this.vars = vars;
        this.templatePath = templatePath;
        Preconditions.checkNotNull((Object)templatePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Step.Result doExecute() throws Exception {
        MDC.put((String)MDC_KEY_TEMPLATE_PATH, (String)this.templatePath);
        try {
            Step.Result result = super.doExecute();
            return result;
        }
        finally {
            MDC.remove((String)MDC_KEY_TEMPLATE_PATH);
        }
    }

    @Override
    protected OverthereFile resolveSourceFile() {
        OverthereFile localTemp = this.getLocalConnection().getTempFile("generic_plugin", ".tmp");
        this.evaluateTemplate(localTemp, this.templatePath, this.vars);
        return localTemp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evaluateTemplate(OverthereFile renderTo, String templatePath, Map<String, Object> vars) {
        block9: {
            Configuration cfg = ConfigurationHolder.getConfiguration();
            OutputStream out = renderTo.getOutputStream();
            try {
                Template template = cfg.getTemplate(templatePath);
                template.process(vars, (Writer)new OutputStreamWriter(out));
                if (!this.logger.isDebugEnabled()) break block9;
                InputStream in = renderTo.getInputStream();
                try {
                    this.logger.debug(new String(ByteStreams.toByteArray((InputStream)in)));
                }
                finally {
                    Closeables.closeQuietly((Closeable)in);
                }
            }
            catch (IOException e) {
                throw new RuntimeIOException((Throwable)e);
            }
            catch (TemplateException e) {
                throw new RuntimeException(e);
            }
            finally {
                Closeables.closeQuietly((Closeable)out);
            }
        }
    }
}

