package com.xebialabs.deployit.plugin.generic.deployed;

import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;
import com.xebialabs.deployit.plugin.generic.ci.Container;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;

import java.util.Collections;
import java.util.Map;

@SuppressWarnings("serial")
@Metadata(description = "Abstract deployed that can target any deployable to a generic container")
public abstract class AbstractDeployed<D extends Deployable> extends BaseDeployed<D, Container> {

    private Map<String,Object> freeMarkerContext = Collections.singletonMap("deployed", (Object) this);

    @Property(defaultValue = "false", hidden = true, description = "The generic container requires a restart for the action performed by this deployed.", required = false)
    private boolean restartRequired;

    @Property(defaultValue = "false", hidden = true, description = "The generic container requires a restart for the NOOP action performed by this deployed.", required=false)
    private boolean restartRequiredForNoop;

    @Property(hidden = true, defaultValue = "50", description = "The order of the step in the step list for the create operation.")
    private int createOrder;

    @Property(hidden = true, defaultValue = "40", description = "The order of the step in the step list for the destroy operation.")
    private int destroyOrder;

    @Property(hidden = true, defaultValue = "50", description = "The order of the step in the step list for the modify operation.")
    private int modifyOrder;

    @Property(hidden = true, defaultValue = "50", description = "The order of the step in the step list for the noop operation.")
    private int noopOrder;

    @Property(hidden = true, defaultValue = "Create")
	private String createVerb;

    @Property(hidden = true, defaultValue = "Modify")
	private String modifyVerb;

	@Property(hidden = true, defaultValue = "Destroy")
	private String destroyVerb;

    @Property(hidden = true, defaultValue = "Modify")
    private String noopVerb;


    public boolean isRestartRequired() {
        return restartRequired;
    }

    public void setRestartRequired(boolean restartRequired) {
        this.restartRequired = restartRequired;
    }

    public int getCreateOrder() {
        return createOrder;
    }

    public void setCreateOrder(int createOrder) {
        this.createOrder = createOrder;
    }

    public int getDestroyOrder() {
        return destroyOrder;
    }

    public void setDestroyOrder(int destroyOrder) {
        this.destroyOrder = destroyOrder;
    }

    public int getModifyOrder() {
        return modifyOrder;
    }

    public void setModifyOrder(int modifyOrder) {
        this.modifyOrder = modifyOrder;
    }

     public String getCreateVerb() {
        return createVerb;
    }

    public void setCreateVerb(String createVerb) {
        this.createVerb = createVerb;
    }

    public String getModifyVerb() {
        return modifyVerb;
    }

    public void setModifyVerb(String modifyVerb) {
        this.modifyVerb = modifyVerb;
    }

    public String getDestroyVerb() {
        return destroyVerb;
    }

    public void setDestroyVerb(String destroyVerb) {
        this.destroyVerb = destroyVerb;
    }

    public int getNoopOrder() {
        return noopOrder;
    }

    public void setNoopOrder(int noopOrder) {
        this.noopOrder = noopOrder;
    }

    public String getNoopVerb() {
        return noopVerb;
    }

    public void setNoopVerb(String noopVerb) {
        this.noopVerb = noopVerb;
    }

    public boolean isRestartRequiredForNoop() {
        return restartRequiredForNoop;
    }

    public void setRestartRequiredForNoop(boolean restartRequiredForNoop) {
        this.restartRequiredForNoop = restartRequiredForNoop;
    }

    public String getDescription(String verb) {
        return String.format("%s %s on %s", verb, getDeployable().getName(), getContainer().getName());
    }

    public Map<String,Object> getDeployedAsFreeMarkerContext() {
        return freeMarkerContext;
    }

    protected String resolveExpression(String expression) {
        return ConfigurationHolder.resolveExpression(expression,getDeployedAsFreeMarkerContext());
    }
}
