/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.step;

import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.generic.ci.Container;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericBaseStep
implements DeploymentStep {
    private int order;
    private String description;
    private Container container;
    private transient OverthereConnection localConn;
    private transient OverthereConnection remoteConn;
    private transient DeploymentExecutionContext ctx;
    private transient OverthereFile remoteWorkingDir;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected GenericBaseStep(int order, String description, Container container) {
        this.order = order;
        this.description = description;
        this.container = container;
    }

    protected GenericBaseStep(int order, Container container) {
        this(order, null, container);
    }

    public int getOrder() {
        return this.order;
    }

    public String getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Step.Result execute(DeploymentExecutionContext ctx) throws Exception {
        try {
            this.ctx = ctx;
            Step.Result result = this.doExecute();
            return result;
        }
        finally {
            this.disconnect();
        }
    }

    protected abstract Step.Result doExecute() throws Exception;

    protected DeploymentExecutionContext getCtx() {
        return this.ctx;
    }

    protected Container getContainer() {
        return this.container;
    }

    protected OverthereFile getRemoteWorkingDirectory() {
        if (this.remoteWorkingDir == null) {
            OverthereFile tempDir = this.getRemoteConnection().getTempFile("generic_plugin", ".tmp");
            tempDir.mkdir();
            this.remoteWorkingDir = tempDir;
        }
        return this.remoteWorkingDir;
    }

    protected OverthereConnection getLocalConnection() {
        if (this.localConn == null) {
            this.localConn = LocalConnection.getLocalConnection();
        }
        return this.localConn;
    }

    protected OverthereConnection getRemoteConnection() {
        if (this.remoteConn == null) {
            this.remoteConn = this.container.getHost().getConnection();
        }
        return this.remoteConn;
    }

    protected void disconnect() {
        if (this.localConn != null) {
            this.localConn.close();
        }
        if (this.remoteConn != null) {
            this.remoteConn.close();
        }
        this.localConn = null;
        this.remoteConn = null;
    }
}

