/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.container;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.generic.ci.Container;
import com.xebialabs.deployit.plugin.generic.deployed.AbstractDeployed;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;
import com.xebialabs.deployit.plugin.generic.step.WaitStep;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class LifeCycleContributor {
    @Contributor
    public void restartContainers(Deltas deltas, DeploymentPlanningContext result) {
        Set<Container> targets = this.gatherTargets(deltas.getDeltas());
        for (Container target : targets) {
            if (!Strings.nullToEmpty((String)target.getRestartScript()).trim().isEmpty()) {
                this.addStep(target.getRestartScript(), target.getRestartOrder(), target, "Restarting", result);
                this.addWaitStep(target.getRestartWaitTime(), target.getRestartOrder(), target, "restart", result);
                continue;
            }
            Preconditions.checkArgument((!Strings.nullToEmpty((String)target.getStartScript()).trim().isEmpty() ? 1 : 0) != 0, (Object)"start script must be specified when no restart script defined.");
            Preconditions.checkArgument((!Strings.nullToEmpty((String)target.getStopScript()).trim().isEmpty() ? 1 : 0) != 0, (Object)"stop script must be specified when no restart script defined.");
            this.addStep(target.getStartScript(), target.getStartOrder(), target, "Starting", result);
            this.addWaitStep(target.getStartWaitTime(), target.getStartOrder(), target, "start", result);
            this.addStep(target.getStopScript(), target.getStopOrder(), target, "Stopping", result);
            this.addWaitStep(target.getStopWaitTime(), target.getStopOrder(), target, "stop", result);
        }
    }

    private void addWaitStep(int waitTime, int scriptOrder, Container target, String action, DeploymentPlanningContext result) {
        if (waitTime > 0) {
            result.addStep((DeploymentStep)new WaitStep(scriptOrder + 1, waitTime, target.getName(), action));
        }
    }

    private void addStep(String script, int scriptOrder, Container container, String verb, DeploymentPlanningContext result) {
        HashMap vars = Maps.newHashMap();
        vars.put("container", container);
        result.addStep((DeploymentStep)new ScriptExecutionStep(scriptOrder, script, container, vars, this.getDescription(verb, container)));
    }

    private String getDescription(String verb, Container container) {
        return String.format("%s %s", verb, container.getName());
    }

    private Set<Container> gatherTargets(List<Delta> operations) {
        TreeSet targets = Sets.newTreeSet();
        for (Delta operation : operations) {
            this.addTarget(targets, operation.getDeployed());
            this.addTarget(targets, operation.getPrevious());
        }
        return targets;
    }

    private void addTarget(Set<Container> targets, Deployed<?, ?> deployed) {
        boolean restartRequired;
        if (deployed == null) {
            return;
        }
        if (deployed instanceof AbstractDeployed && (restartRequired = ((AbstractDeployed)deployed).isRestartRequired())) {
            targets.add((Container)deployed.getContainer());
        }
    }
}

