package com.xebialabs.deployit.plugin.generic.deployed;

import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;

@SuppressWarnings("serial")
@Metadata(virtual = true, description = "A script executed on a generic container")
public class ExecutedScript<D extends Deployable> extends AbstractDeployed<D> {

     @Property(required = true, hidden=true, description = "Classpath to the script that is uploaded and executed on the generic container for the create operation.")
    private String createScript;

    @Property(required = false, hidden=true, description = "Classpath to the script that is uploaded and executed on the generic container for the modify operation.")
    private String modifyScript;

    @Property(required = true, hidden=true, description = "Classpath to the script that is uploaded and executed on the generic container for the destroy operation.")
    private String destroyScript;

    protected boolean addStep(DeploymentPlanningContext ctx, int order, String script, String verb) {
        if (!Strings.nullToEmpty(script).trim().isEmpty()) {
            ctx.addStep(new ScriptExecutionStep(order,script, getContainer(), getDeployedAsFreeMarkerContext() ,getDescription(verb)));
            return true;
        } else {
            return false;
        }
    }

    @Create
    public void executeCreate(DeploymentPlanningContext ctx) {
        addStep(ctx, getCreateOrder(), getCreateScript(), getCreateVerb());
    }

    @Modify
    public void executeModify(DeploymentPlanningContext ctx) {
        boolean modifyStepAdded = addStep(ctx, getModifyOrder(), getModifyScript(), getModifyVerb());
        if (!modifyStepAdded) {
            executeDestroy(ctx);
            executeCreate(ctx);
        }
    }

    @Destroy
    public void executeDestroy(DeploymentPlanningContext ctx) {
        addStep(ctx, getDestroyOrder(), getDestroyScript(), getDestroyVerb());
    }

    public String getCreateScript() {
        return createScript;
    }

    public void setCreateScript(String createScript) {
        this.createScript = createScript;
    }

    public String getModifyScript() {
        return modifyScript;
    }

    public void setModifyScript(String modifyScript) {
        this.modifyScript = modifyScript;
    }

    public String getDestroyScript() {
        return destroyScript;
    }

    public void setDestroyScript(String destroyScript) {
        this.destroyScript = destroyScript;
    }
}
