/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.file.step;

import com.xebialabs.deployit.checksum.ChecksumAlgorithmProvider;
import com.xebialabs.deployit.checksum.DefaultChecksumAlgorithmProviderFactory;
import com.xebialabs.deployit.engine.spi.artifact.resolution.ResolvedArtifactFile;
import com.xebialabs.deployit.io.ArtifactFileUtils;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployableArtifact;
import com.xebialabs.xldeploy.packager.io.StreamerFactory;
import com.xebialabs.xldeploy.packager.placeholders.PlaceholdersUtil;
import com.xebialabs.xldeploy.packager.placeholders.SourceArtifactScanner;
import com.xebialabs.xlplatform.artifact.resolution.ArtifactResolverRegistry;
import java.net.URI;
import java.net.URISyntaxException;

public class RescanArtifactStep
implements Step {
    private final BaseDeployableArtifact artifact;

    public RescanArtifactStep(BaseDeployableArtifact artifact) {
        this.artifact = artifact;
    }

    public int getOrder() {
        return 10;
    }

    public String getDescription() {
        return "Rescan artifact " + this.artifact;
    }

    public StepExitCode execute(ExecutionContext ctx) {
        SourceArtifactScanner scanner = new SourceArtifactScanner(StreamerFactory.defaultMappings());
        ChecksumAlgorithmProvider checksumAlgorithmProvider = DefaultChecksumAlgorithmProviderFactory.defaultComparisonAlgorithm();
        try {
            if (!PlaceholdersUtil.SourceArtifactUtil((SourceArtifact)this.artifact).shouldScanPlaceholders()) {
                ctx.logError("Should not rescan artifact " + this.artifact + ". This CI or doesn't have property `scanPlaceholders` or it is not enabled.");
                return StepExitCode.FAIL;
            }
            if (!this.artifact.getFileUri().startsWith("internal:")) {
                ArtifactFileUtils.handleArtifact((SourceArtifactScanner)scanner, (SourceArtifact)this.artifact, (ChecksumAlgorithmProvider)checksumAlgorithmProvider);
            } else {
                ResolvedArtifactFile resolved = ArtifactResolverRegistry.resolve((SourceArtifact)this.artifact);
                String fileName = this.getFileName();
                PlaceholdersUtil.SourceArtifactUtil((SourceArtifact)this.artifact).addChecksumAndScan(scanner, fileName, resolved.openStream(), () -> ((ChecksumAlgorithmProvider)checksumAlgorithmProvider).getMessageDigest());
            }
            ctx.getRepository().update((ConfigurationItem[])new BaseDeployableArtifact[]{this.artifact});
            ctx.logOutput("Successfully re-scanned placeholders " + this.artifact.getPlaceholders() + " for artifact " + this.artifact + ".");
            return StepExitCode.SUCCESS;
        }
        catch (Exception exc) {
            ctx.logError("Cannot rescan artifact " + this.artifact + ". Please check settings.", (Throwable)exc);
            return StepExitCode.FAIL;
        }
    }

    private String getFileName() throws URISyntaxException {
        URI uri = new URI(this.artifact.getFileUri());
        switch (uri.getScheme()) {
            case "http": 
            case "https": {
                return uri.getPath().substring(uri.getPath().lastIndexOf("/") + 1);
            }
        }
        return uri.getSchemeSpecificPart();
    }
}

