package com.xebialabs.deployit.plugin.file;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployableFileArtifact;

@SuppressWarnings("serial")
@Metadata(description = "A single file artifact that can be packaged in a Deployment Package")
public class File extends BaseDeployableFileArtifact {

    @SuppressWarnings("unused")
    @Property(required = false, description = "Path to which artifact must be copied to when being deployed.")
    private String targetPath;

    @SuppressWarnings("unused")
    @Property(required = false, description = "Is the targetPath shared by others on the host. When true, the targetPath is not deleted during undeployment; only the artifacts copied to it.")
    private String targetPathShared;

    @SuppressWarnings("unused")
    @Property(required = false, description = "Create the targetPath on the host if it does not exist.")
    private String createTargetPath;

    @SuppressWarnings("unused")
    @Property(required = false, description = "Name of the artifact on the host.")
    private String targetFileName;

}
