package com.xebialabs.deployit.plugin.file.deployed;

import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DefaultOrders;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployedArtifact;
import com.xebialabs.deployit.plugin.generic.ci.Container;
import com.xebialabs.deployit.plugin.generic.deployed.CopiedArtifact;
import com.xebialabs.deployit.plugin.overthere.Host;

@SuppressWarnings("serial")
@Metadata(virtual = true, description = "Abstract deployed that can target any DeployableArtifact to a Host.")
public class DeployedArtifactOnHost<D extends DeployableArtifact> extends BaseDeployedArtifact<D, Host> {

    @Property(description = "Path to which artifact must be copied to on the host.")
    private String targetPath;

    @Property(defaultValue = "true", description = "Is the targetPath shared by others on the host. When true, the targetPath is not deleted during undeployment; only the artifacts copied to it.", required = false)
    private boolean targetPathShared;

    @Property(defaultValue = "false", description = "Create the targetPath on the host if it does not exist.", required = false)
    private boolean createTargetPath;

    @Property(required = false, description = "Name of the artifact on the host.")
    private String targetFileName;


    private CopiedArtifact<D> createDelegate() {
        CopiedArtifact<D> delegate = new CopiedArtifact<D>();
        delegate.setSyntheticProperties(this.getSyntheticProperties());
        delegate.setPlaceholders(this.getPlaceholders());
        delegate.setFile(this.getFile());
        delegate.setId(this.getId());

        Container container = new Container();
        container.setHost(getContainer());
        container.setId(getContainer().getId());

        delegate.setContainer(container);
        delegate.setDeployable(getDeployable());

        delegate.setCreateOrder(DefaultOrders.CREATE_RESOURCES);
        delegate.setDestroyOrder(DefaultOrders.DESTROY_RESOURCES);

        delegate.setCreateTargetDirectory(isCreateTargetPath());
        delegate.setTargetFile(getTargetFileName());
        delegate.setTargetDirectory(getTargetPath());
        delegate.setTargetDirectoryShared(isTargetPathShared());
        delegate.setUseDescriptionGeneratedByStep(true);

        return delegate;
    }

    @Create
    public void executeCreate(DeploymentPlanningContext ctx) {
        CopiedArtifact<D> delegate = createDelegate();
        delegate.executeCreate(ctx);
    }

    @Modify
    public void executeModify(DeploymentPlanningContext ctx, Delta d) {
        DeployedArtifactOnHost<D> previous = (DeployedArtifactOnHost<D>) d.getPrevious();
        previous.executeDestroy(ctx);
        executeCreate(ctx);
    }

    @Destroy
    public void executeDestroy(DeploymentPlanningContext ctx) {
        CopiedArtifact<D> delegate = createDelegate();
        delegate.executeDestroy(ctx);
    }

    public String getTargetPath() {
        return targetPath;
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    public boolean isTargetPathShared() {
        return targetPathShared;
    }

    public void setTargetPathShared(boolean targetPathShared) {
        this.targetPathShared = targetPathShared;
    }

    public boolean isCreateTargetPath() {
        return createTargetPath;
    }

    public void setCreateTargetPath(boolean createTargetPath) {
        this.createTargetPath = createTargetPath;
    }

    public String getTargetFileName() {
        return targetFileName;
    }

    public void setTargetFileName(String targetFileName) {
        this.targetFileName = targetFileName;
    }

}
