/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.ec2.steps;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.ec2.ci.Credentials;
import com.xebialabs.deployit.plugin.ec2.util.ServiceFactory;
import org.jclouds.compute.ComputeService;
import org.jclouds.domain.Location;
import org.jclouds.rest.AuthorizationException;

public class ValidateCredentialsStep
implements Step {
    private Credentials credentials;
    private ServiceFactory serviceFactory;

    public ValidateCredentialsStep(Credentials credentials, ServiceFactory serviceFactory) {
        this.credentials = credentials;
        this.serviceFactory = serviceFactory;
    }

    public int getOrder() {
        return 50;
    }

    public String getDescription() {
        return "Validating credentials " + this.credentials.getId();
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        try {
            ctx.logOutput("Connecting to EC2...");
            ComputeService computeService = this.serviceFactory.getComputeService(this.credentials.getKey(), this.credentials.getSecret());
            for (Location location : computeService.listAssignableLocations()) {
                ctx.logOutput("Found available location: " + location.getId() + " :" + location.getDescription());
            }
            ctx.logOutput("Connection succeeded.");
        }
        catch (AuthorizationException e) {
            ctx.logError("Can not authenticate with provided credentials", (Throwable)e);
            return StepExitCode.FAIL;
        }
        return StepExitCode.SUCCESS;
    }
}

