/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.ec2.steps;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.cloud.step.ContextAttribute;
import com.xebialabs.deployit.plugin.cloud.util.ContextHelper;
import com.xebialabs.deployit.plugin.ec2.access.EC2Adapter;
import com.xebialabs.deployit.plugin.ec2.ci.HostTemplate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;

public class CreateInstanceStep
implements Step {
    private HostTemplate template;
    private EC2Adapter ec2Adapter;
    private String instanceName;

    public CreateInstanceStep(HostTemplate template, EC2Adapter ec2Adapter, String instanceName) {
        this.template = template;
        this.instanceName = instanceName != null ? instanceName : "Created by deployit @ " + new Date().toString();
        this.ec2Adapter = ec2Adapter;
    }

    public int getOrder() {
        return 50;
    }

    public String getDescription() {
        return "Create EC2 instance " + this.instanceName + " at " + this.template.getRegion() + "/" + this.template.getAmi();
    }

    public StepExitCode execute(ExecutionContext context) throws Exception {
        try {
            context.logOutput("Making call to EC2 to start new instance...");
            String cloudId = this.ec2Adapter.kickNewInstance(this.template, this.instanceName, this.template.getBootTimeout(), this.template.getRetryDelay(), this.template.getTags());
            context.logOutput("New instance start has been triggered...");
            context.logOutput("Instance id: " + cloudId);
            ContextHelper.wrapped((ExecutionContext)context).safeSet((Enum)ContextAttribute.USED_TEMPLATES, new ArrayList(), Arrays.asList(this.template));
            ContextHelper.wrapped((ExecutionContext)context).safeSet((Enum)ContextAttribute.CREATED_INSTANCES, new ArrayList(), Arrays.asList(cloudId));
            return StepExitCode.SUCCESS;
        }
        catch (IllegalArgumentException e) {
            context.logError("Can not create image template", (Throwable)e);
            return StepExitCode.FAIL;
        }
    }
}

