/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cache;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheLoader;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;

@Beta
public abstract class ForwardingCacheLoader<K, V>
extends CacheLoader<K, V> {
    protected ForwardingCacheLoader() {
    }

    protected abstract CacheLoader<K, V> delegate();

    public V load(K key) throws Exception {
        return (V)this.delegate().load(key);
    }

    public ListenableFuture<V> reload(K key, V oldValue) throws Exception {
        return this.delegate().reload(key, oldValue);
    }

    public Map<K, V> loadAll(Iterable<? extends K> keys) throws Exception {
        return this.delegate().loadAll(keys);
    }

    @Beta
    public static class SimpleForwardingCacheLoader<K, V>
    extends ForwardingCacheLoader<K, V> {
        private final CacheLoader<K, V> delegate;

        protected SimpleForwardingCacheLoader(CacheLoader<K, V> delegate) {
            this.delegate = (CacheLoader)Preconditions.checkNotNull(delegate);
        }

        @Override
        protected final CacheLoader<K, V> delegate() {
            return this.delegate;
        }
    }
}

