/*
 * Decompiled with CFR 0.152.
 */
package org.nnsoft.guice.rocoto.variables;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.nnsoft.guice.rocoto.variables.Appender;
import org.nnsoft.guice.rocoto.variables.KeyAppender;
import org.nnsoft.guice.rocoto.variables.TextAppender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Resolver {
    private static final String VAR_BEGIN = "$";
    private static final String PIPE_SEPARATOR = "|";
    private final List<Appender> appenders = new ArrayList<Appender>();
    private boolean containsKeys = false;

    public Resolver(String pattern) {
        int pos;
        int prev = 0;
        while ((pos = pattern.indexOf(VAR_BEGIN, prev)) >= 0) {
            if (pos > 0) {
                this.appenders.add(new TextAppender(pattern.substring(prev, pos)));
            }
            if (pos == pattern.length() - 1) {
                this.appenders.add(new TextAppender(VAR_BEGIN));
                prev = pos + 1;
                continue;
            }
            if (pattern.charAt(pos + 1) != '{') {
                if (pattern.charAt(pos + 1) == '$') {
                    this.appenders.add(new TextAppender(VAR_BEGIN));
                    prev = pos + 2;
                    continue;
                }
                this.appenders.add(new TextAppender(pattern.substring(pos, pos + 2)));
                prev = pos + 2;
                continue;
            }
            int endName = pattern.indexOf(125, pos);
            if (endName < 0) {
                throw new IllegalArgumentException("Syntax error in property: " + pattern);
            }
            String key = pattern.substring(pos + 2, endName);
            int pipeIndex = key.indexOf(PIPE_SEPARATOR);
            if (pipeIndex >= 0) {
                this.appenders.add(new KeyAppender(key.substring(0, pipeIndex).trim(), key.substring(pipeIndex + 1).trim()));
            } else {
                this.appenders.add(new KeyAppender(key));
            }
            prev = endName + 1;
            this.containsKeys = true;
        }
        if (prev < pattern.length()) {
            this.appenders.add(new TextAppender(pattern.substring(prev)));
        }
    }

    public boolean containsKeys() {
        return this.containsKeys;
    }

    public String resolve(Map<String, String> configuration) {
        StringBuilder buffer = new StringBuilder();
        for (Appender appender : this.appenders) {
            appender.append(buffer, configuration);
        }
        return buffer.toString();
    }

    public String toString() {
        return this.appenders.toString();
    }
}

