/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cim.xml;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.net.URI;
import org.jclouds.cim.VirtualSystemSettingData;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class VirtualSystemSettingDataHandler
extends ParseSax.HandlerWithResult<VirtualSystemSettingData> {
    protected StringBuilder currentText = new StringBuilder();
    protected VirtualSystemSettingData.Builder builder = VirtualSystemSettingData.builder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualSystemSettingData getResult() {
        try {
            VirtualSystemSettingData virtualSystemSettingData = this.builder.build();
            return virtualSystemSettingData;
        }
        finally {
            this.builder = VirtualSystemSettingData.builder();
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) {
    }

    public void endElement(String uri, String localName, String qName) {
        String current = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        if (current != null) {
            if (SaxUtils.equalsOrSuffix((String)qName, (String)"ElementName")) {
                this.builder.elementName(current);
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"InstanceID")) {
                this.builder.instanceID(current);
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Caption")) {
                this.builder.caption(current);
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Description")) {
                this.builder.description(current);
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"AutomaticRecoveryAction")) {
                this.builder.automaticRecoveryAction(VirtualSystemSettingData.AutomaticRecoveryAction.fromValue(current));
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"AutomaticShutdownAction")) {
                this.builder.automaticShutdownAction(VirtualSystemSettingData.AutomaticShutdownAction.fromValue(current));
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"AutomaticStartupAction")) {
                this.builder.automaticStartupAction(VirtualSystemSettingData.AutomaticStartupAction.fromValue(current));
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"AutomaticStartupActionDelay")) {
                this.builder.automaticStartupActionDelay(null);
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"AutomaticStartupActionSequenceNumber")) {
                this.builder.automaticStartupActionSequenceNumber(Integer.valueOf(current));
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"ConfigurationDataRoot")) {
                this.builder.configurationDataRoot(URI.create(current));
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"ConfigurationFile")) {
                this.builder.configurationFile(URI.create(current));
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"ConfigurationID")) {
                this.builder.configurationID(current);
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"CreationTime")) {
                this.builder.creationTime(null);
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"LogDataRoot")) {
                this.builder.logDataRoot(URI.create(current));
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"RecoveryFile")) {
                this.builder.recoveryFile(URI.create(current));
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"RecoveryFile")) {
                this.builder.recoveryFile(URI.create(current));
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"SuspendDataRoot")) {
                this.builder.suspendDataRoot(URI.create(current));
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"SwapFileDataRoot")) {
                this.builder.swapFileDataRoot(URI.create(current));
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"VirtualSystemIdentifier")) {
                this.builder.virtualSystemIdentifier(current);
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"VirtualSystemType")) {
                this.builder.virtualSystemTypes(Iterables.filter((Iterable)Iterables.transform((Iterable)Splitter.on((char)',').split((CharSequence)current), (Function)new Function<String, String>(){

                    public String apply(String input) {
                        return input.trim();
                    }
                }), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)""))));
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Notes")) {
                this.builder.notes(current);
            }
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

