/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.config;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import com.google.inject.Provides;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.aws.handlers.AWSClientErrorRetryHandler;
import org.jclouds.aws.handlers.ParseAWSErrorFromXmlContent;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.config.RestClientModule;

@ConfiguresRestClient
public abstract class AWSRestClientModule<S, A>
extends RestClientModule<S, A> {
    protected AWSRestClientModule(Map<Class<?>, Class<?>> delegates) {
        super(delegates);
    }

    protected AWSRestClientModule() {
    }

    protected AWSRestClientModule(TypeToken<S> syncClientType, TypeToken<A> asyncClientType) {
        super(syncClientType, asyncClientType);
    }

    protected AWSRestClientModule(TypeToken<S> syncClientType, TypeToken<A> asyncClientType, Map<Class<?>, Class<?>> sync2Async) {
        super(syncClientType, asyncClientType, sync2Async);
    }

    @Provides
    @ClientError
    @Singleton
    protected Set<String> provideRetryableCodes() {
        return ImmutableSet.of((Object)"RequestTimeout", (Object)"OperationAborted", (Object)"SignatureDoesNotMatch");
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(ParseAWSErrorFromXmlContent.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(ParseAWSErrorFromXmlContent.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(ParseAWSErrorFromXmlContent.class);
    }

    protected void bindRetryHandlers() {
        this.bind(HttpRetryHandler.class).annotatedWith(ClientError.class).to(AWSClientErrorRetryHandler.class);
    }
}

