/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws;

import org.jclouds.aws.domain.AWSError;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;

public class AWSResponseException
extends HttpResponseException {
    private static final long serialVersionUID = 1L;
    private AWSError error = new AWSError();

    public AWSResponseException(HttpCommand command, HttpResponse response, AWSError error) {
        super(String.format("request %s failed with code %s, error: %s", command.getCurrentRequest().getRequestLine(), response.getStatusCode(), error.toString()), command, response);
        this.setError(error);
    }

    public AWSResponseException(HttpCommand command, HttpResponse response, AWSError error, Throwable cause) {
        super(String.format("request %1$s failed with error: %2$s", command.getCurrentRequest().getRequestLine(), error.toString()), command, response, cause);
        this.setError(error);
    }

    public AWSResponseException(String message, HttpCommand command, HttpResponse response, AWSError error) {
        super(message, command, response);
        this.setError(error);
    }

    public AWSResponseException(String message, HttpCommand command, HttpResponse response, AWSError error, Throwable cause) {
        super(message, command, response, cause);
        this.setError(error);
    }

    public void setError(AWSError error) {
        this.error = error;
    }

    public AWSError getError() {
        return this.error;
    }
}

