/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.util;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;

@Deprecated
public class TagFilters {
    protected final Map<FilterName, Iterable<?>> map = Maps.newLinkedHashMap();

    protected TagFilters() {
    }

    public static TagFilters filters() {
        return new TagFilters();
    }

    public Map<FilterName, Iterable<?>> build() {
        return ImmutableMap.copyOf(this.map);
    }

    public TagFilters resourceId(String resourceId) {
        this.put(FilterName.RESOURCE_ID, resourceId);
        return this;
    }

    public TagFilters key(String key) {
        this.put(FilterName.KEY, key);
        return this;
    }

    public TagFilters keys(String ... keys) {
        this.put(FilterName.KEY, ImmutableSet.copyOf((Object[])keys));
        return this;
    }

    public TagFilters keys(Iterable<String> keys) {
        this.putAll(FilterName.KEY, (Iterable<?>)ImmutableSet.copyOf(keys));
        return this;
    }

    public TagFilters value(String value) {
        this.put(FilterName.VALUE, value);
        return this;
    }

    public TagFilters values(String ... values) {
        this.putAll(FilterName.VALUE, (Iterable<?>)ImmutableSet.copyOf((Object[])values));
        return this;
    }

    public TagFilters values(Iterable<String> values) {
        this.putAll(FilterName.VALUE, (Iterable<?>)ImmutableSet.copyOf(values));
        return this;
    }

    public TagFilters keyContains(String key) {
        return this.key(String.format("*%s*", key));
    }

    public TagFilters valueContains(String value) {
        return this.value(String.format("*%s*", value));
    }

    public TagFilters resourceIdContains(String value) {
        return this.resourceId(String.format("*%s*", value));
    }

    public TagFilters keyStartsWith(String key) {
        return this.key(String.format("%s*", key));
    }

    public TagFilters valueStartsWith(String value) {
        return this.value(String.format("%s*", value));
    }

    public TagFilters resourceIdStartsWith(String value) {
        return this.resourceId(String.format("%s*", value));
    }

    public TagFilters keyEndsWith(String key) {
        return this.key(String.format("*%s", key));
    }

    public TagFilters valueEndsWith(String value) {
        return this.value(String.format("*%s", value));
    }

    public TagFilters resourceIdEndsWith(String value) {
        return this.resourceId(String.format("*%s", value));
    }

    public TagFilters keyValuePair(String key, String value) {
        return this.key(key).value(value);
    }

    public TagFilters keyValueSet(String key, Iterable<String> values) {
        return this.key(key).values(values);
    }

    public TagFilters keyValueSet(String key, String ... values) {
        return this.key(key).values(values);
    }

    public TagFilters anyKey() {
        this.putAll(FilterName.KEY, (Iterable<?>)ImmutableSet.of());
        return this;
    }

    public TagFilters anyValue() {
        this.putAll(FilterName.VALUE, (Iterable<?>)ImmutableSet.of());
        return this;
    }

    public TagFilters anyResourceId() {
        this.putAll(FilterName.RESOURCE_TYPE, (Iterable<?>)ImmutableSet.of());
        return this;
    }

    public TagFilters anyResourceType() {
        this.putAll(FilterName.RESOURCE_TYPE, (Iterable<?>)ImmutableSet.of());
        return this;
    }

    public TagFilters resourceType(ResourceType resourceType) {
        this.put(FilterName.RESOURCE_TYPE, (Object)resourceType);
        return this;
    }

    public TagFilters customerGateway() {
        this.put(FilterName.RESOURCE_TYPE, (Object)ResourceType.CUSTOMER_GATEWAY);
        return this;
    }

    public TagFilters dhcpOptions() {
        this.put(FilterName.RESOURCE_TYPE, (Object)ResourceType.DHCP_OPTIONS);
        return this;
    }

    public TagFilters image() {
        this.put(FilterName.RESOURCE_TYPE, (Object)ResourceType.IMAGE);
        return this;
    }

    public TagFilters instance() {
        this.put(FilterName.RESOURCE_TYPE, (Object)ResourceType.INSTANCE);
        return this;
    }

    public TagFilters internetGateway() {
        this.put(FilterName.RESOURCE_TYPE, (Object)ResourceType.INTERNET_GATEWAY);
        return this;
    }

    public TagFilters networkAcl() {
        this.put(FilterName.RESOURCE_TYPE, (Object)ResourceType.NETWORK_ACL);
        return this;
    }

    public TagFilters reservedInstance() {
        this.put(FilterName.RESOURCE_TYPE, (Object)ResourceType.RESERVED_INSTANCES);
        return this;
    }

    public TagFilters routeTable() {
        this.put(FilterName.RESOURCE_TYPE, (Object)ResourceType.ROUTE_TABLE);
        return this;
    }

    public TagFilters securityGroup() {
        this.put(FilterName.RESOURCE_TYPE, (Object)ResourceType.SECURITY_GROUP);
        return this;
    }

    public TagFilters snapshot() {
        this.put(FilterName.RESOURCE_TYPE, (Object)ResourceType.SNAPSHOT);
        return this;
    }

    public TagFilters instancesRequest() {
        this.put(FilterName.RESOURCE_TYPE, (Object)ResourceType.SPOT_INSTANCES_REQUEST);
        return this;
    }

    public TagFilters subnet() {
        this.put(FilterName.RESOURCE_TYPE, (Object)ResourceType.SUBNET);
        return this;
    }

    public TagFilters volume() {
        this.put(FilterName.RESOURCE_TYPE, (Object)ResourceType.VOLUME);
        return this;
    }

    public TagFilters vpc() {
        this.put(FilterName.RESOURCE_TYPE, (Object)ResourceType.VPC);
        return this;
    }

    public TagFilters vpnConnection() {
        this.put(FilterName.RESOURCE_TYPE, (Object)ResourceType.VPN_CONNECTION);
        return this;
    }

    public TagFilters vpnGateway() {
        this.put(FilterName.RESOURCE_TYPE, (Object)ResourceType.VPN_GATEWAY);
        return this;
    }

    private void put(FilterName key, Object value) {
        this.putAll(key, Sets.newHashSet((Object[])new Object[]{value}));
    }

    private void putAll(FilterName key, Iterable<?> values) {
        if (values == null || Iterables.isEmpty(values)) {
            this.map.put(key, (Iterable<?>)ImmutableSet.of());
        } else {
            if (!this.map.containsKey((Object)key)) {
                this.map.put(key, Sets.newHashSet());
            }
            Iterable<?> entries = this.map.get((Object)key);
            this.map.put(key, Iterables.concat(entries, values));
        }
    }

    @Deprecated
    public static enum ResourceType {
        CUSTOMER_GATEWAY,
        DHCP_OPTIONS,
        IMAGE,
        INSTANCE,
        INTERNET_GATEWAY,
        NETWORK_ACL,
        RESERVED_INSTANCES,
        ROUTE_TABLE,
        SECURITY_GROUP,
        SNAPSHOT,
        SPOT_INSTANCES_REQUEST,
        SUBNET,
        VOLUME,
        VPC,
        VPN_CONNECTION,
        VPN_GATEWAY;


        public String value() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, this.name());
        }

        public String toString() {
            return this.value();
        }

        public static ResourceType fromValue(String name) {
            try {
                return ResourceType.valueOf(CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)name, (Object)"name")));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }

    public static enum FilterName {
        KEY,
        RESOURCE_ID,
        RESOURCE_TYPE,
        VALUE;


        public String value() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, this.name());
        }

        public String toString() {
            return this.value();
        }

        public static FilterName fromValue(String name) {
            try {
                return FilterName.valueOf(CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)name, (Object)"name")));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }
}

