/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cim.functions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import javax.inject.Singleton;
import org.jclouds.cim.CIMPredicates;
import org.jclouds.cim.ResourceAllocationSettingData;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.internal.VolumeImpl;

@Singleton
public class HardwareBuilderFromResourceAllocations
implements Function<Iterable<? extends ResourceAllocationSettingData>, HardwareBuilder> {
    public HardwareBuilder apply(Iterable<? extends ResourceAllocationSettingData> from) {
        HardwareBuilder builder = new HardwareBuilder();
        builder.volumes(Iterables.transform((Iterable)Iterables.filter(from, CIMPredicates.resourceTypeIn(ResourceAllocationSettingData.ResourceType.DISK_DRIVE, ResourceAllocationSettingData.ResourceType.BASE_PARTITIONABLE_UNIT, ResourceAllocationSettingData.ResourceType.PARTITIONABLE_UNIT)), (Function)new Function<ResourceAllocationSettingData, Volume>(){

            public Volume apply(ResourceAllocationSettingData from) {
                return HardwareBuilderFromResourceAllocations.this.apply(from);
            }
        }));
        builder.ram((int)((ResourceAllocationSettingData)Iterables.find(from, CIMPredicates.resourceTypeIn(ResourceAllocationSettingData.ResourceType.MEMORY))).getVirtualQuantity().longValue());
        builder.processors(Iterables.transform((Iterable)Iterables.filter(from, CIMPredicates.resourceTypeIn(ResourceAllocationSettingData.ResourceType.PROCESSOR)), (Function)new Function<ResourceAllocationSettingData, Processor>(){

            public Processor apply(ResourceAllocationSettingData arg0) {
                return new Processor(arg0.getVirtualQuantity().longValue(), 1.0);
            }
        }));
        return builder;
    }

    public Volume apply(ResourceAllocationSettingData from) {
        return new VolumeImpl(from.getAddressOnParent() + "", Volume.Type.LOCAL, from.getVirtualQuantity() == null ? null : Float.valueOf((float)(from.getVirtualQuantity() / 1024L) / 1024.0f), null, "0".equals(from.getAddressOnParent()) || ResourceAllocationSettingData.ResourceType.BASE_PARTITIONABLE_UNIT.equals((Object)from.getResourceType()), true);
    }
}

