/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.domain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.net.URI;
import java.util.Map;
import org.jclouds.scriptbuilder.domain.AppendFile;
import org.jclouds.scriptbuilder.domain.Call;
import org.jclouds.scriptbuilder.domain.CreateOrOverwriteFile;
import org.jclouds.scriptbuilder.domain.CreateRunScript;
import org.jclouds.scriptbuilder.domain.InterpretableStatement;
import org.jclouds.scriptbuilder.domain.Kill;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.PipeHttpResponseToBash;
import org.jclouds.scriptbuilder.domain.PipeHttpResponseToTarxpzfIntoDirectory;
import org.jclouds.scriptbuilder.domain.SaveHttpResponseTo;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.jclouds.scriptbuilder.domain.SwitchArg;
import org.jclouds.scriptbuilder.domain.UnzipHttpResponseIntoDirectory;

public class Statements {
    private static final Kill KILL = new Kill();

    public static Statement newStatementList(Statement ... statements) {
        return new StatementList(statements);
    }

    public static Statement switchArg(int arg, Map<String, Statement> valueToActions) {
        return new SwitchArg(arg, valueToActions);
    }

    public static Statement rm(final String path) {
        return new Statement(){

            @Override
            public Iterable<String> functionDependencies(OsFamily family) {
                return ImmutableList.of();
            }

            @Override
            public String render(OsFamily family) {
                if (family == OsFamily.WINDOWS) {
                    return Statements.exec(String.format("{rm} %s 2{closeFd}", path)).render(family);
                }
                return Statements.exec(String.format("{rm} %s", path)).render(family);
            }
        };
    }

    public static Statement call(String function, String ... args) {
        return new Call(function, args);
    }

    public static Statement appendFile(String path, String line, String delimiter) {
        return AppendFile.builder().path(path).lines((Iterable<String>)ImmutableSet.of((Object)line)).delimiter(delimiter).build();
    }

    public static Statement appendFile(String path, Iterable<String> lines) {
        return AppendFile.builder().path(path).lines(lines).build();
    }

    public static Statement appendFile(String path, Iterable<String> lines, String delimiter) {
        return AppendFile.builder().path(path).lines(lines).delimiter(delimiter).build();
    }

    public static Statement createOrOverwriteFile(String path, Iterable<String> lines) {
        return ((CreateOrOverwriteFile.Builder)CreateOrOverwriteFile.builder().path(path).lines((Iterable)lines)).build();
    }

    public static Statement createOrOverwriteFile(String path, Iterable<String> lines, String delimiter) {
        return ((CreateOrOverwriteFile.Builder)CreateOrOverwriteFile.builder().path(path).lines((Iterable)lines)).delimiter(delimiter).build();
    }

    public static CreateRunScript createRunScript(String instanceName, Iterable<String> exports, String pwd, Iterable<Statement> statements) {
        return new CreateRunScript(instanceName, exports, pwd, statements);
    }

    public static Statement findPid(String args) {
        return new Call("findPid", args);
    }

    public static Statement forget(String instanceName, String script, String logDir) {
        return new Call("forget", instanceName, script, logDir);
    }

    public static Statement kill() {
        return KILL;
    }

    public static Statement interpret(String ... portableStatements) {
        return new InterpretableStatement(portableStatements);
    }

    public static Statement exec(String portableStatement) {
        return Statements.interpret(portableStatement + "{lf}");
    }

    public static Statement extractTargzIntoDirectory(String method, URI endpoint, Multimap<String, String> headers, String directory) {
        return new PipeHttpResponseToTarxpzfIntoDirectory(method, endpoint, headers, directory);
    }

    public static Statement extractTargzAndFlattenIntoDirectory(URI tgz, String dest) {
        return new StatementList((Iterable<Statement>)ImmutableSet.builder().add((Object)Statements.exec("mkdir /tmp/$$")).add((Object)Statements.extractTargzIntoDirectory(tgz, "/tmp/$$")).add((Object)Statements.exec("mkdir -p " + dest)).add((Object)Statements.exec("mv /tmp/$$/*/* " + dest)).add((Object)Statements.exec("rm -rf /tmp/$$")).build());
    }

    public static Statement extractTargzIntoDirectory(URI targz, String directory) {
        return Statements.extractTargzIntoDirectory("GET", targz, (Multimap<String, String>)ImmutableMultimap.of(), directory);
    }

    public static Statement extractZipIntoDirectory(String method, URI endpoint, Multimap<String, String> headers, String directory) {
        return new UnzipHttpResponseIntoDirectory(method, endpoint, headers, directory);
    }

    public static Statement saveHttpResponseTo(URI source, String dir, String file) {
        return new SaveHttpResponseTo(dir, file, "GET", source, (Multimap<String, String>)ImmutableMultimap.of());
    }

    public static Statement pipeHttpResponseToBash(String method, URI endpoint, Multimap<String, String> headers) {
        return new PipeHttpResponseToBash(method, endpoint, headers);
    }
}

