/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.domain;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.jclouds.scriptbuilder.ExitInsteadOfReturn;
import org.jclouds.scriptbuilder.ScriptBuilder;
import org.jclouds.scriptbuilder.domain.AppendFile;
import org.jclouds.scriptbuilder.domain.Call;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.ShellToken;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.scriptbuilder.util.Utils;

public class CreateRunScript
extends StatementList {
    public static final String DELIMITER = "END_OF_JCLOUDS_SCRIPT";
    final String instanceName;
    final Iterable<String> exports;
    final String pwd;

    public CreateRunScript(String instanceName, Iterable<String> exports, String pwd, Iterable<Statement> statements) {
        super(statements);
        this.instanceName = (String)Preconditions.checkNotNull((Object)instanceName, (Object)"INSTANCE_NAME");
        this.exports = (Iterable)Preconditions.checkNotNull(exports, (Object)"exports");
        this.pwd = ((String)Preconditions.checkNotNull((Object)pwd, (Object)"pwd")).replaceAll("[/\\\\]", "{fs}");
    }

    @Override
    public Iterable<String> functionDependencies(OsFamily family) {
        return Collections.emptyList();
    }

    @Override
    public String render(OsFamily family) {
        if (Preconditions.checkNotNull((Object)((Object)family), (Object)"family") == OsFamily.WINDOWS) {
            throw new UnsupportedOperationException("windows not yet implemented");
        }
        ArrayList statements = Lists.newArrayList();
        Map<String, String> tokenMap = ShellToken.tokenValueMap(family);
        String runScript = Utils.replaceTokens(this.pwd + "{fs}" + this.instanceName + ".{sh}", tokenMap);
        statements.add(Statements.interpret(String.format("{md} %s{lf}", this.pwd)));
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        this.addUnixRunScriptHeader(runScript, builder);
        builder.append("\n");
        this.addUnixRunScript(runScript, builder);
        builder.append("\n");
        this.addUnixRunScriptFooter(runScript, builder);
        builder.append("\n");
        statements.add(Statements.interpret(builder.toString()));
        statements.add(Statements.exec("chmod u+x " + runScript));
        return new StatementList(statements).render(family);
    }

    private void addUnixRunScriptFooter(String runScript, StringBuilder builder) {
        builder.append("# add runscript footer\n");
        Iterable endScript = Splitter.on((String)ShellToken.LF.to(OsFamily.UNIX)).split((CharSequence)ShellToken.END_SCRIPT.to(OsFamily.UNIX));
        builder.append(Statements.appendFile(runScript, endScript, DELIMITER).render(OsFamily.UNIX));
    }

    private void addUnixRunScript(String runScript, StringBuilder builder) {
        builder.append("# add desired commands from the user\n");
        ImmutableList.Builder userCommands = ImmutableList.builder();
        userCommands.add((Object)("cd " + this.pwd));
        for (Statement statement : this.statements) {
            if (statement instanceof Call || statement instanceof StatementList && Iterables.any((Iterable)((StatementList)StatementList.class.cast(statement)).delegate(), (Predicate)Predicates.instanceOf(Call.class))) {
                statement = new ExitInsteadOfReturn(statement);
            }
            userCommands.addAll(Splitter.on((char)'\n').split((CharSequence)statement.render(OsFamily.UNIX)));
        }
        builder.append(Statements.appendFile(runScript, (Iterable<String>)userCommands.build(), DELIMITER).render(OsFamily.UNIX));
    }

    private void addUnixRunScriptHeader(String runScript, StringBuilder builder) {
        builder.append("# create runscript header\n");
        ImmutableList.Builder beginningOfFile = ImmutableList.builder();
        beginningOfFile.addAll(Splitter.on((String)ShellToken.LF.to(OsFamily.UNIX)).split((CharSequence)ShellToken.BEGIN_SCRIPT.to(OsFamily.UNIX)));
        beginningOfFile.add((Object)String.format("PROMPT_COMMAND='echo -ne \\\"\\033]0;%s\\007\\\"'", this.instanceName));
        beginningOfFile.add((Object)Utils.writeZeroPath(OsFamily.UNIX));
        beginningOfFile.add((Object)String.format("export INSTANCE_NAME='%s'", this.instanceName));
        builder.append(Statements.createOrOverwriteFile(runScript, (Iterable<String>)beginningOfFile.build(), DELIMITER).render(OsFamily.UNIX));
        builder.append(AppendFile.builder().path(runScript).delimiter(DELIMITER).expandVariables(true).lines(Iterables.transform(this.exports, (Function)new Function<String, String>(){

            public String apply(String export) {
                return "export " + export + "='$" + export + "'";
            }
        })).build().render(OsFamily.UNIX));
        Map<String, String> functionsToWrite = ScriptBuilder.resolveFunctionDependenciesForStatements((Map<String, String>)ImmutableMap.of((Object)"abort", (Object)Utils.writeFunctionFromResource("abort", OsFamily.UNIX)), this.statements, OsFamily.UNIX);
        if (functionsToWrite.size() > 1) {
            StringBuilder functions = new StringBuilder();
            ScriptBuilder.writeFunctions(functionsToWrite, OsFamily.UNIX, functions);
            builder.append(Statements.appendFile(runScript, functions.toString(), DELIMITER).render(OsFamily.UNIX));
        }
    }

    public static class AddExport
    implements Statement {
        final String export;
        final String value;
        public static final Map<OsFamily, String> OS_TO_EXPORT_PATTERN = ImmutableMap.of((Object)((Object)OsFamily.UNIX), (Object)"export {export}='{value}'\n", (Object)((Object)OsFamily.WINDOWS), (Object)"set {export}={value}\r\n");

        public AddExport(String export, String value) {
            this.export = (String)Preconditions.checkNotNull((Object)export, (Object)"export");
            this.value = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
        }

        @Override
        public Iterable<String> functionDependencies(OsFamily family) {
            return Collections.emptyList();
        }

        @Override
        public String render(OsFamily family) {
            return Utils.replaceTokens(OS_TO_EXPORT_PATTERN.get((Object)family), (Map<String, String>)ImmutableMap.of((Object)"export", (Object)this.export, (Object)"value", (Object)this.value));
        }
    }
}

