/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.strategy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.crypto.SshKeys;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.domain.RegionNameAndIngressRules;
import org.jclouds.ec2.compute.options.EC2TemplateOptions;
import org.jclouds.ec2.domain.BlockDeviceMapping;
import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.ec2.options.RunInstancesOptions;
import org.jclouds.javax.annotation.Nullable;

@Singleton
public class CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions {
    @VisibleForTesting
    public Function<RegionAndName, KeyPair> makeKeyPair;
    @VisibleForTesting
    public final ConcurrentMap<RegionAndName, KeyPair> credentialsMap;
    @VisibleForTesting
    public final LoadingCache<RegionAndName, String> securityGroupMap;
    @VisibleForTesting
    public final Provider<RunInstancesOptions> optionsProvider;
    private final GroupNamingConvention.Factory namingConvention;

    @Inject
    public CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions(Function<RegionAndName, KeyPair> makeKeyPair, ConcurrentMap<RegionAndName, KeyPair> credentialsMap, @Named(value="SECURITY") LoadingCache<RegionAndName, String> securityGroupMap, Provider<RunInstancesOptions> optionsProvider, GroupNamingConvention.Factory namingConvention) {
        this.makeKeyPair = (Function)Preconditions.checkNotNull(makeKeyPair, (Object)"makeKeyPair");
        this.credentialsMap = (ConcurrentMap)Preconditions.checkNotNull(credentialsMap, (Object)"credentialsMap");
        this.securityGroupMap = (LoadingCache)Preconditions.checkNotNull(securityGroupMap, (Object)"securityGroupMap");
        this.optionsProvider = (Provider)Preconditions.checkNotNull(optionsProvider, (Object)"optionsProvider");
        this.namingConvention = (GroupNamingConvention.Factory)Preconditions.checkNotNull((Object)namingConvention, (Object)"namingConvention");
    }

    public RunInstancesOptions execute(String region, String group, Template template) {
        RunInstancesOptions instanceOptions = ((RunInstancesOptions)((Object)this.getOptionsProvider().get())).asType(template.getHardware().getId());
        String keyPairName = this.createNewKeyPairUnlessUserSpecifiedOtherwise(region, group, template.getOptions());
        this.addSecurityGroups(region, group, template, instanceOptions);
        if (template.getOptions() instanceof EC2TemplateOptions) {
            Set<BlockDeviceMapping> blockDeviceMappings;
            byte[] userData;
            if (keyPairName != null) {
                instanceOptions.withKeyName(keyPairName);
            }
            if ((userData = ((EC2TemplateOptions)EC2TemplateOptions.class.cast(template.getOptions())).getUserData()) != null) {
                instanceOptions.withUserData(userData);
            }
            if ((blockDeviceMappings = ((EC2TemplateOptions)EC2TemplateOptions.class.cast(template.getOptions())).getBlockDeviceMappings()).size() > 0) {
                Preconditions.checkState((boolean)"ebs".equals(template.getImage().getUserMetadata().get("rootDeviceType")), (Object)"BlockDeviceMapping only available on ebs boot");
                instanceOptions.withBlockDeviceMappings(blockDeviceMappings);
            }
        }
        return instanceOptions;
    }

    protected void addSecurityGroups(String region, String group, Template template, RunInstancesOptions instanceOptions) {
        Set<String> groups = this.getSecurityGroupsForTagAndOptions(region, group, template.getOptions());
        instanceOptions.withSecurityGroups(groups);
    }

    @VisibleForTesting
    public String createNewKeyPairUnlessUserSpecifiedOtherwise(String region, String group, TemplateOptions options) {
        String keyPairName = null;
        boolean shouldAutomaticallyCreateKeyPair = true;
        if (options instanceof EC2TemplateOptions && (keyPairName = ((EC2TemplateOptions)EC2TemplateOptions.class.cast(options)).getKeyPair()) == null) {
            shouldAutomaticallyCreateKeyPair = ((EC2TemplateOptions)EC2TemplateOptions.class.cast(options)).shouldAutomaticallyCreateKeyPair();
        }
        if (keyPairName == null && shouldAutomaticallyCreateKeyPair) {
            keyPairName = this.createOrImportKeyPair(region, group, options);
        } else if (keyPairName != null && options.getLoginPrivateKey() != null) {
            String pem = options.getLoginPrivateKey();
            KeyPair keyPair = KeyPair.builder().region(region).keyName(keyPairName).fingerprint(SshKeys.fingerprintPrivateKey((String)pem)).sha1OfPrivateKey(SshKeys.sha1PrivateKey((String)pem)).keyMaterial(pem).build();
            RegionAndName key = new RegionAndName(region, keyPairName);
            this.credentialsMap.put(key, keyPair);
        }
        if (options.getRunScript() != null) {
            RegionAndName regionAndName = new RegionAndName(region, keyPairName);
            Preconditions.checkArgument((boolean)this.credentialsMap.containsKey(regionAndName), (String)"no private key configured for: %s; please use options.overrideLoginCredentialWith(rsa_private_text)", (Object[])new Object[]{regionAndName});
        }
        return keyPairName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createOrImportKeyPair(String region, String group, TemplateOptions options) {
        KeyPair keyPair;
        RegionAndName regionAndGroup = new RegionAndName(region, group);
        ConcurrentMap<RegionAndName, KeyPair> concurrentMap = this.credentialsMap;
        synchronized (concurrentMap) {
            if (this.credentialsMap.containsKey(regionAndGroup)) {
                return ((KeyPair)this.credentialsMap.get(regionAndGroup)).getKeyName();
            }
            keyPair = (KeyPair)this.makeKeyPair.apply((Object)new RegionAndName(region, group));
            this.credentialsMap.put(regionAndGroup, keyPair);
        }
        this.credentialsMap.put(new RegionAndName(region, keyPair.getKeyName()), keyPair);
        return keyPair.getKeyName();
    }

    @VisibleForTesting
    public Set<String> getSecurityGroupsForTagAndOptions(String region, @Nullable String group, TemplateOptions options) {
        ImmutableSet.Builder groups = ImmutableSet.builder();
        if (group != null) {
            RegionNameAndIngressRules regionNameAndIngessRulesForMarkerGroup;
            String markerGroup = this.namingConvention.create().sharedNameForGroup(group);
            groups.add((Object)markerGroup);
            if (this.userSpecifiedTheirOwnGroups(options)) {
                regionNameAndIngessRulesForMarkerGroup = new RegionNameAndIngressRules(region, markerGroup, new int[0], false);
                groups.addAll(((EC2TemplateOptions)EC2TemplateOptions.class.cast(options)).getGroups());
            } else {
                regionNameAndIngessRulesForMarkerGroup = new RegionNameAndIngressRules(region, markerGroup, options.getInboundPorts(), true);
            }
            this.securityGroupMap.getUnchecked((Object)regionNameAndIngessRulesForMarkerGroup);
        }
        return groups.build();
    }

    protected boolean userSpecifiedTheirOwnGroups(TemplateOptions options) {
        return options instanceof EC2TemplateOptions && ((EC2TemplateOptions)EC2TemplateOptions.class.cast(options)).getGroups().size() > 0;
    }

    @VisibleForTesting
    public Provider<RunInstancesOptions> getOptionsProvider() {
        return this.optionsProvider;
    }
}

