/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.predicates;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.compute.domain.Image;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.compute.functions.EC2ImageParser;
import org.jclouds.ec2.options.DescribeImagesOptions;
import org.jclouds.logging.Logger;
import org.jclouds.predicates.PredicateWithResult;

public final class GetImageWhenStatusAvailablePredicateWithResult
implements PredicateWithResult<String, Image> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final EC2Client ec2Client;
    private final EC2ImageParser ec2ImageToImage;
    private org.jclouds.ec2.domain.Image result;
    private RuntimeException lastFailure;

    @Inject
    public GetImageWhenStatusAvailablePredicateWithResult(EC2Client ec2Client, EC2ImageParser ec2ImageToImage) {
        this.ec2Client = ec2Client;
        this.ec2ImageToImage = ec2ImageToImage;
    }

    public boolean apply(String input) {
        String[] parts = AWSUtils.parseHandle((String)input);
        String region = parts[0];
        String imageId = parts[1];
        this.result = (org.jclouds.ec2.domain.Image)Preconditions.checkNotNull((Object)this.findImage(imageId, region));
        switch (this.result.getImageState()) {
            case AVAILABLE: {
                this.logger.info("<< Image %s is available for use.", new Object[]{input});
                return true;
            }
            case UNRECOGNIZED: {
                this.logger.debug("<< Image %s is not available yet.", new Object[]{input});
                return false;
            }
        }
        this.lastFailure = new IllegalStateException("Image was not created: " + input);
        throw this.lastFailure;
    }

    public Image getResult() {
        return this.ec2ImageToImage.apply(this.result);
    }

    public Throwable getLastFailure() {
        return this.lastFailure;
    }

    private org.jclouds.ec2.domain.Image findImage(String id, String region) {
        return (org.jclouds.ec2.domain.Image)Iterables.getOnlyElement(this.ec2Client.getAMIServices().describeImagesInRegion(region, new DescribeImagesOptions().imageIds(id)));
    }
}

