/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.ec2.steps;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.ec2.ci.HostTemplate;
import com.xebialabs.deployit.plugin.ec2.util.ServiceFactory;

public class DestroyInstanceStep
implements Step {
    private ServiceFactory serviceFactory;
    private String cloudId;
    private HostTemplate template;

    public DestroyInstanceStep(ConfigurationItem instance, ServiceFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
        this.cloudId = (String)instance.getProperty("cloudId");
        this.template = (HostTemplate)((Object)instance.getProperty("template"));
    }

    public int getOrder() {
        return 50;
    }

    public String getDescription() {
        return "Destroy EC2 instance " + this.cloudId;
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        ctx.logOutput("Destroying instance " + this.cloudId + " with credentials " + this.template.getCredentials().getId());
        this.serviceFactory.getEC2Adapter(this.template.getCredentials()).shutDown(this.template.getRegion(), this.cloudId);
        return StepExitCode.SUCCESS;
    }
}

