/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.ec2.access;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.cloud.util.Retrier;
import com.xebialabs.deployit.plugin.ec2.ci.Credentials;
import com.xebialabs.deployit.plugin.ec2.ci.HostTemplate;
import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import org.jclouds.ContextBuilder;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.domain.InstanceState;
import org.jclouds.ec2.domain.Reservation;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.ec2.features.TagApi;
import org.jclouds.ec2.options.RunInstancesOptions;
import org.jclouds.rest.RestContext;

public class EC2Adapter
implements Serializable {
    protected Credentials credentials;
    private int actionTimeout = 20;
    private int retryDelay = 5;

    public EC2Adapter(Credentials credentials) {
        this.credentials = credentials;
    }

    public String kickNewInstance(HostTemplate nodeTemplate, String instanceLabel) throws TimeoutException {
        return this.kickNewInstance(nodeTemplate, instanceLabel, this.actionTimeout, this.retryDelay);
    }

    public String kickNewInstance(final HostTemplate nodeTemplate, String instanceLabel, int actionTimeout, int retryDelay) throws TimeoutException {
        final EC2Client client = this.client(this.credentials);
        Reservation started = client.getInstanceServices().runInstancesInRegion(nodeTemplate.getRegion(), null, nodeTemplate.getAmi(), 1, 1, new RunInstancesOptions[]{RunInstancesOptions.Builder.asType((String)nodeTemplate.getInstanceType().getValue()).withKeyName(nodeTemplate.getKeyPair()).withSecurityGroups(nodeTemplate.getGroups())});
        final RunningInstance instance = (RunningInstance)Iterables.getOnlyElement((Iterable)started);
        final HashMap tags = Maps.newHashMap();
        tags.put("Name", instanceLabel);
        new Retrier((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                ((TagApi)client.getTagApiForRegion(nodeTemplate.getRegion()).get()).applyToResources(tags, (Iterable)Lists.newArrayList((Object[])new String[]{instance.getId()}));
                return true;
            }
        }).retryFor(actionTimeout, retryDelay);
        return instance.getId();
    }

    public String waitUntilInstanceIsRunning(String region, String instanceId) throws TimeoutException {
        return this.waitUntilInstanceIsRunning(region, instanceId, this.actionTimeout, this.retryDelay);
    }

    public String waitUntilInstanceIsRunning(final String region, final String instanceId, int actionTimeout, int retryDelay) throws TimeoutException {
        final EC2Client client = this.client(this.credentials);
        return (String)new Retrier((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                RunningInstance instance = (RunningInstance)Iterables.getOnlyElement((Iterable)((Iterable)Iterables.getOnlyElement((Iterable)client.getInstanceServices().describeInstancesInRegion(region, new String[]{instanceId}))));
                if (InstanceState.RUNNING.equals((Object)instance.getInstanceState())) {
                    return instance.getIpAddress();
                }
                throw new IllegalStateException("Expected state to be RUNNING, got " + instance.getInstanceState() + " instead");
            }
        }).retryFor(actionTimeout, retryDelay);
    }

    public String getPublicIpAddress(String region, String instanceId) {
        return ((RunningInstance)Iterables.getOnlyElement((Iterable)((Iterable)Iterables.getOnlyElement((Iterable)this.client(this.credentials).getInstanceServices().describeInstancesInRegion(region, new String[]{instanceId}))))).getIpAddress();
    }

    public void shutDown(String region, String cloudId) {
        this.client(this.credentials).getInstanceServices().terminateInstancesInRegion(region, new String[]{cloudId});
    }

    private EC2Client client(Credentials credentials) {
        RestContext context = (RestContext)ContextBuilder.newBuilder((String)"aws-ec2").credentials(credentials.getKey(), credentials.getSecret()).build();
        return (EC2Client)context.getApi();
    }
}

