/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.functions;

import com.google.common.base.Function;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.domain.AWSRunningInstance;
import org.jclouds.aws.ec2.domain.LaunchSpecification;
import org.jclouds.aws.ec2.domain.MonitoringState;
import org.jclouds.aws.ec2.domain.SpotInstanceRequest;
import org.jclouds.ec2.domain.Hypervisor;
import org.jclouds.ec2.domain.InstanceState;

@Singleton
public class SpotInstanceRequestToAWSRunningInstance
implements Function<SpotInstanceRequest, AWSRunningInstance> {
    public AWSRunningInstance apply(SpotInstanceRequest request) {
        if (request == null) {
            return null;
        }
        if (request.getState() != SpotInstanceRequest.State.OPEN) {
            return null;
        }
        AWSRunningInstance.Builder builder = AWSRunningInstance.builder();
        builder.spotInstanceRequestId(request.getId());
        builder.instanceId(request.getId());
        builder.instanceState(InstanceState.PENDING);
        builder.rawState(request.getRawState());
        builder.region(request.getRegion());
        builder.tags(request.getTags());
        LaunchSpecification spec = request.getLaunchSpecification();
        builder.availabilityZone(spec.getAvailabilityZone());
        builder.groupNames(spec.getSecurityGroupNames());
        builder.imageId(spec.getImageId());
        builder.instanceType(spec.getInstanceType());
        builder.kernelId(spec.getKernelId());
        builder.keyName(spec.getKeyName());
        builder.ramdiskId(spec.getRamdiskId());
        builder.monitoringState(Boolean.TRUE.equals(spec.isMonitoringEnabled()) ? MonitoringState.PENDING : MonitoringState.DISABLED);
        builder.hypervisor(Hypervisor.XEN);
        return builder.build();
    }
}

