/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.AWSEC2Client;
import org.jclouds.aws.ec2.domain.SpotInstanceRequest;
import org.jclouds.aws.ec2.functions.SpotInstanceRequestToAWSRunningInstance;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.compute.strategy.EC2GetNodeMetadataStrategy;
import org.jclouds.ec2.domain.RunningInstance;

@Singleton
public class AWSEC2GetNodeMetadataStrategy
extends EC2GetNodeMetadataStrategy {
    private final AWSEC2Client client;
    private final SpotInstanceRequestToAWSRunningInstance spotConverter;

    @Inject
    protected AWSEC2GetNodeMetadataStrategy(AWSEC2Client client, Function<RunningInstance, NodeMetadata> runningInstanceToNodeMetadata, SpotInstanceRequestToAWSRunningInstance spotConverter) {
        super((EC2Client)client, runningInstanceToNodeMetadata);
        this.client = (AWSEC2Client)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.spotConverter = (SpotInstanceRequestToAWSRunningInstance)Preconditions.checkNotNull((Object)spotConverter, (Object)"spotConverter");
    }

    public RunningInstance getRunningInstanceInRegion(String region, String id) {
        if (id.indexOf("sir-") != 0) {
            return super.getRunningInstanceInRegion(region, id);
        }
        SpotInstanceRequest spot = (SpotInstanceRequest)Iterables.getOnlyElement(this.client.getSpotInstanceServices().describeSpotInstanceRequestsInRegion(region, id));
        if (spot.getState() == SpotInstanceRequest.State.ACTIVE) {
            return super.getRunningInstanceInRegion(region, spot.getInstanceId());
        }
        return this.spotConverter.apply(spot);
    }
}

