/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloud.validation;

import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.cloud.ci.BaseHostTemplate;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Rule(clazz=Validator.class, type="marker-file-check")
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface MarkerFileValidation {

    public static class Validator
    implements com.xebialabs.deployit.plugin.api.validation.Validator<BaseHostTemplate> {
        public void validate(BaseHostTemplate value, ValidationContext context) {
            if (!Strings.isNullOrEmpty((String)value.getMarkerPath())) {
                this.check(value.getConnectionType() != null, context, "Connection type");
                this.check(value.getOs() != null, context, "Operating system");
                this.check(!Strings.isNullOrEmpty((String)value.getUsername()), context, "Username");
                this.check(!Strings.isNullOrEmpty((String)value.getPassword()) || !Strings.isNullOrEmpty((String)value.getPrivateKeyFile()), context, "Password or private key file");
                if (value.getRetryDelay() <= 0) {
                    context.error("Retry delay should be > 0", new Object[0]);
                }
            }
        }

        private void check(boolean b, ValidationContext context, String s) {
            if (!b) {
                context.error("%s should be provided when marker file set.", new Object[]{s});
            }
        }
    }
}

