/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloud.step;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.cloud.step.rule.ResultCheck;
import com.xebialabs.deployit.plugin.cloud.util.CiParser;
import com.xebialabs.deployit.plugin.cloud.util.InstanceDescriptorResolver;
import freemarker.template.TemplateException;
import java.util.List;
import java.util.Map;

public abstract class ValidateDescriptorStep
implements Step {
    protected InstanceDescriptorResolver descriptorResolver;
    protected CiParser ciParser;
    protected Map<Object, Object> scope = Maps.newHashMap();
    private String descriptorTemplate;
    private String templateName;
    private ResultCheck resultCheck;

    public ValidateDescriptorStep(String descriptorTemplate, String templateName, ResultCheck resultCheck) {
        this.descriptorResolver = new InstanceDescriptorResolver();
        this.ciParser = new CiParser();
        this.descriptorTemplate = descriptorTemplate;
        this.templateName = templateName;
        this.resultCheck = resultCheck;
    }

    public String getDescription() {
        return "Validate XML descriptor for " + this.templateName;
    }

    public int getOrder() {
        return 50;
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        String descriptor;
        try {
            descriptor = this.resolveTemplate(this.descriptorTemplate, this.scope, ctx);
            ctx.logOutput("Successfully processed descriptor template...");
            ctx.logOutput("-------------------------------------------");
            this.outputDescriptor(descriptor, ctx);
            ctx.logOutput("-------------------------------------------");
        }
        catch (Exception e) {
            ctx.logError("Can not process descriptor template.");
            ctx.logError(e.getMessage());
            return StepExitCode.FAIL;
        }
        try {
            List<ConfigurationItem> cis = this.parseCis(descriptor, ctx);
            ctx.logOutput("Successfully parsed " + cis.size() + " CIs");
            this.resultCheck.check(cis);
            return StepExitCode.SUCCESS;
        }
        catch (ResultCheck.Failed e) {
            ctx.logError("Resulted CIs don't meet expectation: " + e.getMessage());
            return StepExitCode.FAIL;
        }
        catch (Exception e) {
            ctx.logError("Can not parse generated XML. " + e.getMessage());
            return StepExitCode.FAIL;
        }
    }

    protected abstract String resolveTemplate(String var1, Map<Object, Object> var2, ExecutionContext var3) throws TemplateException;

    protected abstract List<ConfigurationItem> parseCis(String var1, ExecutionContext var2);

    protected void outputDescriptor(String descriptor, ExecutionContext ctx) {
        ctx.logOutput(descriptor);
    }
}

