/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.internal;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.internal.ClassMethodArgs;
import org.jclouds.io.Payload;
import org.jclouds.javax.annotation.Nullable;

public class GeneratedHttpRequest
extends HttpRequest {
    private final Class<?> declaring;
    private final Method javaMethod;
    private final List<Object> args;
    private final Optional<ClassMethodArgs> caller;

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        return new Builder().fromGeneratedHttpRequest(this);
    }

    protected GeneratedHttpRequest(String method, URI endpoint, Multimap<String, String> headers, @Nullable Payload payload, Class<?> declaring, Method javaMethod, Iterable<Object> args, Iterable<HttpRequestFilter> filters, Optional<ClassMethodArgs> caller) {
        super(method, endpoint, headers, payload, filters);
        this.declaring = (Class)Preconditions.checkNotNull(declaring, (Object)"declaring");
        this.javaMethod = (Method)Preconditions.checkNotNull((Object)javaMethod, (Object)"javaMethod");
        this.args = Lists.newArrayList((Iterable)((Iterable)Preconditions.checkNotNull(args, (Object)"args")));
        this.caller = (Optional)Preconditions.checkNotNull(caller, (Object)"caller");
    }

    public Class<?> getDeclaring() {
        return this.declaring;
    }

    public Method getJavaMethod() {
        return this.javaMethod;
    }

    public List<Object> getArgs() {
        return Collections.unmodifiableList(this.args);
    }

    public Optional<ClassMethodArgs> getCaller() {
        return this.caller;
    }

    public static class Builder
    extends HttpRequest.Builder<Builder> {
        protected Class<?> declaring;
        protected Method javaMethod;
        protected List<Object> args = Lists.newArrayList();
        protected Optional<ClassMethodArgs> caller = Optional.absent();

        public Builder declaring(Class<?> declaring) {
            this.declaring = (Class)Preconditions.checkNotNull(declaring, (Object)"declaring");
            return this;
        }

        public Builder javaMethod(Method javaMethod) {
            this.javaMethod = (Method)Preconditions.checkNotNull((Object)javaMethod, (Object)"javaMethod");
            return this;
        }

        public Builder args(Iterable<Object> args) {
            this.args = Lists.newArrayList((Iterable)((Iterable)Preconditions.checkNotNull(args, (Object)"args")));
            return this;
        }

        public Builder args(@Nullable Object[] args) {
            return this.args(Arrays.asList(args != null ? args : new Object[]{}));
        }

        public Builder arg(@Nullable Object arg) {
            this.args.add(arg);
            return this;
        }

        public Builder caller(@Nullable ClassMethodArgs caller) {
            this.caller = Optional.fromNullable((Object)caller);
            return this;
        }

        @Override
        public GeneratedHttpRequest build() {
            return new GeneratedHttpRequest(this.method, this.endpoint, (Multimap<String, String>)this.headers.build(), this.payload, this.declaring, this.javaMethod, this.args, (Iterable<HttpRequestFilter>)this.filters.build(), this.caller);
        }

        public Builder fromGeneratedHttpRequest(GeneratedHttpRequest in) {
            return ((Builder)super.fromHttpRequest(in)).declaring(in.getDeclaring()).javaMethod(in.getJavaMethod()).args(in.getArgs()).caller((ClassMethodArgs)in.getCaller().orNull());
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

