/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpResponseException;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.rest.functions.PropagateIfRetryAfter;

@Singleton
public class MapHttp4xxCodesToExceptions
implements Function<Exception, Object> {
    private final PropagateIfRetryAfter propagateIfRetryAfter;

    @Inject
    protected MapHttp4xxCodesToExceptions(PropagateIfRetryAfter propagateIfRetryAfter) {
        this.propagateIfRetryAfter = (PropagateIfRetryAfter)Preconditions.checkNotNull((Object)propagateIfRetryAfter, (Object)"propagateIfRetryAfter");
    }

    public Object apply(Exception from) {
        HttpResponseException responseException;
        this.propagateIfRetryAfter.apply(from);
        if (from instanceof HttpResponseException && (responseException = (HttpResponseException)from).getResponse() != null) {
            switch (responseException.getResponse().getStatusCode()) {
                case 401: {
                    throw new AuthorizationException(from);
                }
                case 403: {
                    throw new AuthorizationException(from);
                }
                case 404: {
                    throw new ResourceNotFoundException(from);
                }
                case 409: {
                    throw new IllegalStateException(from);
                }
            }
        }
        throw Throwables.propagate((Throwable)from);
    }
}

