/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.predicates;

import com.google.common.net.HostAndPort;
import com.google.inject.Inject;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.predicates.SocketOpen;

@Singleton
public class InetSocketAddressConnect
implements SocketOpen {
    @Resource
    protected Logger logger = Logger.NULL;
    @Inject(optional=true)
    @Named(value="org.jclouds.socket_timeout")
    private int timeout = 2000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean apply(HostAndPort socketA) {
        InetSocketAddress socketAddress = new InetSocketAddress(socketA.getHostText(), socketA.getPort());
        Socket socket = null;
        try {
            this.logger.trace("testing socket %s", socketAddress);
            socket = new Socket();
            socket.setReuseAddress(false);
            socket.setSoLinger(false, 1);
            socket.setSoTimeout(this.timeout);
            socket.connect(socketAddress, this.timeout);
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException ioe) {}
            }
        }
        return true;
    }
}

