/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.json.internal;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class IgnoreNullFluentIterableTypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Type type = typeToken.getType();
        if (typeToken.getRawType() != FluentIterable.class || !(type instanceof ParameterizedType)) {
            return null;
        }
        Type elementType = ((ParameterizedType)type).getActualTypeArguments()[0];
        TypeAdapter elementAdapter = gson.getAdapter(TypeToken.get((Type)elementType));
        return this.newFluentIterableAdapter(elementAdapter);
    }

    protected <E> TypeAdapter<FluentIterable<E>> newFluentIterableAdapter(final TypeAdapter<E> elementAdapter) {
        return new TypeAdapter<FluentIterable<E>>(){

            public void write(JsonWriter out, FluentIterable<E> value) throws IOException {
                out.beginArray();
                for (Object element : value) {
                    elementAdapter.write(out, element);
                }
                out.endArray();
            }

            public FluentIterable<E> read(JsonReader in) throws IOException {
                in.beginArray();
                ImmutableList.Builder builder = ImmutableList.builder();
                while (in.hasNext()) {
                    Object element = elementAdapter.read(in);
                    if (element == null) continue;
                    builder.add(element);
                }
                in.endArray();
                return FluentIterable.from((Iterable)builder.build());
            }
        }.nullSafe();
    }
}

