/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.io;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.payloads.BaseImmutableContentMetadata;
import org.jclouds.javax.annotation.Nullable;

public class ContentMetadataBuilder
implements Serializable {
    private static final long serialVersionUID = -5279643002875371558L;
    protected String contentType = "application/unknown";
    protected Long contentLength;
    protected byte[] contentMD5;
    protected String contentDisposition;
    protected String contentLanguage;
    protected String contentEncoding;
    protected Date expires;

    public static ContentMetadataBuilder create() {
        return new ContentMetadataBuilder();
    }

    public ContentMetadataBuilder contentLength(@Nullable Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public ContentMetadataBuilder contentMD5(byte[] md5) {
        if (md5 != null) {
            byte[] retval = new byte[md5.length];
            System.arraycopy(md5, 0, retval, 0, md5.length);
            this.contentMD5 = md5;
        }
        return this;
    }

    public ContentMetadataBuilder contentType(@Nullable String contentType) {
        this.contentType = contentType;
        return this;
    }

    public ContentMetadataBuilder contentDisposition(@Nullable String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public ContentMetadataBuilder contentLanguage(@Nullable String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    public ContentMetadataBuilder contentEncoding(@Nullable String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public ContentMetadataBuilder expires(@Nullable Date expires) {
        this.expires = expires;
        return this;
    }

    public ContentMetadata build() {
        return new BaseImmutableContentMetadata(this.contentType, this.contentLength, this.contentMD5, this.contentDisposition, this.contentLanguage, this.contentEncoding, this.expires);
    }

    public static ContentMetadataBuilder fromContentMetadata(ContentMetadata in) {
        return new ContentMetadataBuilder().contentType(in.getContentType()).contentLength(in.getContentLength()).contentMD5(in.getContentMD5()).contentDisposition(in.getContentDisposition()).contentLanguage(in.getContentLanguage()).contentEncoding(in.getContentEncoding()).expires(in.getExpires());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.contentDisposition, this.contentEncoding, this.contentLanguage, this.contentLength, this.contentMD5, this.contentType, this.expires});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentMetadataBuilder other = (ContentMetadataBuilder)obj;
        return Objects.equal((Object)this.contentDisposition, (Object)other.contentDisposition) && Objects.equal((Object)this.contentEncoding, (Object)other.contentEncoding) && Objects.equal((Object)this.contentLanguage, (Object)other.contentLanguage) && Objects.equal((Object)this.contentLength, (Object)other.contentLength) && Arrays.equals(this.contentMD5, other.contentMD5) && Objects.equal((Object)this.contentType, (Object)other.contentType) && Objects.equal((Object)this.expires, (Object)other.expires);
    }

    public String toString() {
        return "[contentDisposition=" + this.contentDisposition + ", contentEncoding=" + this.contentEncoding + ", contentLanguage=" + this.contentLanguage + ", contentLength=" + this.contentLength + ", contentMD5=" + Arrays.toString(this.contentMD5) + ", contentType=" + this.contentType + ", expires=" + this.expires + "]";
    }
}

