/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingObject;
import com.google.common.reflect.TypeToken;
import javax.inject.Singleton;
import org.jclouds.Context;
import org.jclouds.View;
import org.jclouds.location.Provider;

@Singleton
public abstract class BaseView
extends ForwardingObject
implements View {
    private final Context backend;
    private final TypeToken<? extends Context> backendType;

    protected BaseView(@Provider Context backend, @Provider TypeToken<? extends Context> backendType) {
        this.backend = (Context)Preconditions.checkNotNull((Object)backend, (Object)"backend");
        this.backendType = (TypeToken)Preconditions.checkNotNull(backendType, (Object)"backendType");
    }

    @Override
    public <C extends Context> C unwrap(TypeToken<C> type) {
        Preconditions.checkArgument((boolean)((TypeToken)Preconditions.checkNotNull(type, (Object)"type")).isAssignableFrom(this.backendType), (String)"backend type: %s not assignable from %s", (Object[])new Object[]{this.backendType, type});
        return (C)this.backend;
    }

    @Override
    public <C extends Context> C unwrap(Class<C> clazz) {
        return this.unwrap(TypeToken.of((Class)((Class)Preconditions.checkNotNull(clazz, (Object)"clazz"))));
    }

    public TypeToken<? extends Context> getBackendType() {
        return this.backendType;
    }

    @Override
    public <C extends Context> C unwrap() throws ClassCastException {
        return (C)this.unwrap(this.getBackendType());
    }

    protected Context delegate() {
        return this.backend;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseView that = (BaseView)BaseView.class.cast(o);
        return Objects.equal((Object)this.delegate(), (Object)that.delegate()) && Objects.equal(this.getBackendType(), that.getBackendType());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.delegate(), this.getBackendType()});
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("backend", (Object)this.delegate()).add("backendType", this.getBackendType());
    }
}

