/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.internal;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.common.io.NullOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpCommandExecutorService;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.IOExceptionRetryHandler;
import org.jclouds.http.handlers.DelegatingErrorHandler;
import org.jclouds.http.handlers.DelegatingRetryHandler;
import org.jclouds.http.internal.HttpWire;
import org.jclouds.io.ContentMetadataCodec;
import org.jclouds.logging.Logger;
import org.jclouds.util.Throwables2;

public abstract class BaseHttpCommandExecutorService<Q>
implements HttpCommandExecutorService {
    protected final HttpUtils utils;
    protected final ContentMetadataCodec contentMetadataCodec;
    private final DelegatingRetryHandler retryHandler;
    private final IOExceptionRetryHandler ioRetryHandler;
    private final DelegatingErrorHandler errorHandler;
    private final ExecutorService ioWorkerExecutor;
    @Resource
    protected Logger logger = Logger.NULL;
    @Resource
    @Named(value="jclouds.headers")
    protected Logger headerLog = Logger.NULL;
    protected final HttpWire wire;

    @Inject
    protected BaseHttpCommandExecutorService(HttpUtils utils, ContentMetadataCodec contentMetadataCodec, @Named(value="jclouds.io-worker-threads") ExecutorService ioWorkerExecutor, DelegatingRetryHandler retryHandler, IOExceptionRetryHandler ioRetryHandler, DelegatingErrorHandler errorHandler, HttpWire wire) {
        this.utils = (HttpUtils)Preconditions.checkNotNull((Object)utils, (Object)"utils");
        this.contentMetadataCodec = (ContentMetadataCodec)Preconditions.checkNotNull((Object)contentMetadataCodec, (Object)"contentMetadataCodec");
        this.retryHandler = (DelegatingRetryHandler)Preconditions.checkNotNull((Object)retryHandler, (Object)"retryHandler");
        this.ioRetryHandler = (IOExceptionRetryHandler)Preconditions.checkNotNull((Object)ioRetryHandler, (Object)"ioRetryHandler");
        this.errorHandler = (DelegatingErrorHandler)Preconditions.checkNotNull((Object)errorHandler, (Object)"errorHandler");
        this.ioWorkerExecutor = (ExecutorService)Preconditions.checkNotNull((Object)ioWorkerExecutor, (Object)"ioWorkerExecutor");
        this.wire = (HttpWire)Preconditions.checkNotNull((Object)wire, (Object)"wire");
    }

    public static InputStream consumeOnClose(InputStream in) {
        return new ConsumeOnCloseInputStream(in);
    }

    @Override
    public Future<HttpResponse> submit(HttpCommand command) {
        HttpRequest request = command.getCurrentRequest();
        HttpUtils.checkRequestHasContentLengthOrChunkedEncoding(request, "if the request has a payload, it must be set to chunked encoding or specify a content length: " + request);
        return this.ioWorkerExecutor.submit(new HttpResponseCallable(command));
    }

    protected abstract Q convert(HttpRequest var1) throws IOException, InterruptedException;

    protected abstract HttpResponse invoke(Q var1) throws IOException, InterruptedException;

    protected abstract void cleanup(Q var1);

    public class HttpResponseCallable
    implements Callable<HttpResponse> {
        private final HttpCommand command;

        public HttpResponseCallable(HttpCommand command) {
            this.command = command;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public HttpResponse call() throws Exception {
            HttpResponse response = null;
            while (true) {
                HttpRequest request = this.command.getCurrentRequest();
                Object nativeRequest = null;
                try {
                    for (HttpRequestFilter filter : request.getFilters()) {
                        request = filter.filter(request);
                    }
                    HttpUtils.checkRequestHasContentLengthOrChunkedEncoding(request, "After filtering, the request has neither chunked encoding nor content length: " + request);
                    BaseHttpCommandExecutorService.this.logger.debug("Sending request %s: %s", request.hashCode(), request.getRequestLine());
                    HttpUtils.wirePayloadIfEnabled(BaseHttpCommandExecutorService.this.wire, request);
                    BaseHttpCommandExecutorService.this.utils.logRequest(BaseHttpCommandExecutorService.this.headerLog, request, ">>");
                    nativeRequest = BaseHttpCommandExecutorService.this.convert(request);
                    response = BaseHttpCommandExecutorService.this.invoke(nativeRequest);
                    BaseHttpCommandExecutorService.this.logger.debug("Receiving response %s: %s", request.hashCode(), response.getStatusLine());
                    BaseHttpCommandExecutorService.this.utils.logResponse(BaseHttpCommandExecutorService.this.headerLog, response, "<<");
                    if (response.getPayload() != null && BaseHttpCommandExecutorService.this.wire.enabled()) {
                        BaseHttpCommandExecutorService.this.wire.input(response);
                    }
                    nativeRequest = null;
                    int statusCode = response.getStatusCode();
                    if (statusCode < 300 || !this.shouldContinue(response)) break;
                    continue;
                }
                catch (Exception e) {
                    IOException ioe = Throwables2.getFirstThrowableOfType(e, IOException.class);
                    if (ioe != null && BaseHttpCommandExecutorService.this.ioRetryHandler.shouldRetryRequest(this.command, ioe)) continue;
                    this.command.setException(new HttpResponseException(e.getMessage() + " connecting to " + this.command.getCurrentRequest().getRequestLine(), this.command, null, (Throwable)e));
                }
                finally {
                    BaseHttpCommandExecutorService.this.cleanup(nativeRequest);
                    continue;
                }
                break;
            }
            if (this.command.getException() != null) {
                throw this.command.getException();
            }
            return response;
        }

        private boolean shouldContinue(HttpResponse response) {
            boolean shouldContinue = false;
            if (BaseHttpCommandExecutorService.this.retryHandler.shouldRetryRequest(this.command, response)) {
                shouldContinue = true;
            } else {
                BaseHttpCommandExecutorService.this.errorHandler.handleError(this.command, response);
            }
            return shouldContinue;
        }

        public String toString() {
            return this.command.toString();
        }
    }

    static class ConsumeOnCloseInputStream
    extends FilterInputStream {
        boolean closed;

        protected ConsumeOnCloseInputStream(InputStream in) {
            super(in);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (!this.closed) {
                try {
                    ByteStreams.copy((InputStream)this, (OutputStream)new NullOutputStream());
                }
                catch (IOException iOException) {
                }
                finally {
                    this.closed = true;
                    super.close();
                }
            }
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }
}

