/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ForwardingMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jclouds.http.UriTemplates;
import org.jclouds.http.utils.Queries;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.util.Strings2;

@Beta
public final class Uris {
    public static UriBuilder uriBuilder(CharSequence template) {
        return new UriBuilder(template);
    }

    public static UriBuilder uriBuilder(URI uri) {
        return new UriBuilder(uri);
    }

    private static String slash(CharSequence left, CharSequence right) {
        return Uris.delimit(left, right, '/');
    }

    private static String delimit(CharSequence left, CharSequence right, char token) {
        if (left.length() == 0) {
            return ((Object)right).toString();
        }
        if (right.length() == 0) {
            return ((Object)left).toString();
        }
        StringBuilder builder = new StringBuilder(left);
        if (Uris.lastChar(left) == token) {
            if (Uris.firstChar(right) == token) {
                return builder.append(right.subSequence(1, right.length())).toString();
            }
            return builder.append(right).toString();
        }
        if (Uris.firstChar(right) == token) {
            return builder.append(right).toString();
        }
        return new StringBuilder(left).append(token).append(right).toString();
    }

    public static boolean lastCharIsToken(CharSequence left, char token) {
        return Uris.lastChar(left) == token;
    }

    public static char lastChar(CharSequence in) {
        return in.charAt(in.length() - 1);
    }

    public static char firstChar(CharSequence in) {
        return in.charAt(0);
    }

    public static boolean isToken(CharSequence right, char token) {
        return right.length() == 1 && right.charAt(0) == token;
    }

    private static String prefixIfNeeded(String in) {
        if (in != null && in.charAt(0) != '/') {
            return '/' + in;
        }
        return in;
    }

    static final class DecodingMultimap
    extends ForwardingMultimap<String, Object> {
        private final Multimap<String, Object> delegate = LinkedHashMultimap.create();
        private final Function<Object, Object> urlDecoder = new Function<Object, Object>(){

            public Object apply(Object in) {
                return Strings2.urlDecode(in);
            }
        };

        DecodingMultimap() {
        }

        private static Multimap<String, Object> create() {
            return new DecodingMultimap();
        }

        public boolean put(String key, Object value) {
            return super.put((Object)Strings2.urlDecode(key), (Object)Strings2.urlDecode(value));
        }

        public boolean putAll(String key, Iterable<? extends Object> values) {
            return super.putAll((Object)Strings2.urlDecode(key), Iterables.transform(values, this.urlDecoder));
        }

        public boolean putAll(Multimap<? extends String, ? extends Object> multimap) {
            return super.putAll(multimap);
        }

        public Collection<Object> replaceValues(String key, Iterable<? extends Object> values) {
            return super.replaceValues((Object)Strings2.urlDecode(key), Iterables.transform(values, this.urlDecoder));
        }

        protected Multimap<String, Object> delegate() {
            return this.delegate;
        }

        static /* synthetic */ Multimap access$200() {
            return DecodingMultimap.create();
        }
    }

    public static final class UriBuilder {
        private Iterable<Character> skipPathEncoding = Lists.charactersOf((String)"/:;=");
        private String scheme;
        private String host;
        private Integer port;
        private String path;
        private Multimap<String, Object> query = DecodingMultimap.access$200();

        public UriBuilder skipPathEncoding(Iterable<Character> skipPathEncoding) {
            this.skipPathEncoding = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(skipPathEncoding, (Object)"skipPathEncoding")));
            return this;
        }

        public UriBuilder scheme(String scheme) {
            this.scheme = (String)Preconditions.checkNotNull((Object)scheme, (Object)"scheme");
            return this;
        }

        public UriBuilder host(String host) {
            this.host = (String)Preconditions.checkNotNull((Object)host, (Object)"host");
            return this;
        }

        public UriBuilder clearPath() {
            this.path = null;
            return this;
        }

        public UriBuilder path(@Nullable String path) {
            this.path = (path = Strings.emptyToNull((String)path)) == null ? null : Uris.prefixIfNeeded(Strings2.urlDecode(path));
            return this;
        }

        public UriBuilder appendPath(String path) {
            path = Strings2.urlDecode(Preconditions.checkNotNull((Object)path, (Object)"path"));
            if (this.path == null) {
                this.path(path);
            } else {
                this.path(Uris.slash(this.path, path));
            }
            return this;
        }

        public UriBuilder query(Map<String, ?> parameters) {
            return this.query((Multimap<String, ?>)Multimaps.forMap(parameters));
        }

        public UriBuilder query(@Nullable String queryLine) {
            if (this.query == null) {
                return this.clearQuery();
            }
            return this.query((Multimap)Queries.queryParser().apply((Object)queryLine));
        }

        public UriBuilder clearQuery() {
            this.query.clear();
            return this;
        }

        public UriBuilder query(Multimap<String, ?> parameters) {
            Preconditions.checkNotNull(parameters, (Object)"parameters");
            this.query.clear();
            this.query.putAll(parameters);
            return this;
        }

        public UriBuilder addQuery(String name, Iterable<?> values) {
            this.query.putAll(Preconditions.checkNotNull((Object)name, (Object)"name"), (Iterable)Preconditions.checkNotNull(values, (String)"values of %s", (Object[])new Object[]{name}));
            return this;
        }

        public UriBuilder addQuery(String name, String ... values) {
            return this.addQuery(name, Arrays.asList((Object[])Preconditions.checkNotNull((Object)values, (String)"values of %s", (Object[])new Object[]{name})));
        }

        public UriBuilder addQuery(Map<String, ?> parameters) {
            return this.addQuery((Multimap<String, ?>)Multimaps.forMap(parameters));
        }

        public UriBuilder addQuery(Multimap<String, ?> parameters) {
            this.query.putAll((Multimap)Preconditions.checkNotNull(parameters, (Object)"parameters"));
            return this;
        }

        public UriBuilder replaceQuery(String name, Iterable<?> values) {
            this.query.replaceValues(Preconditions.checkNotNull((Object)name, (Object)"name"), (Iterable)Preconditions.checkNotNull(values, (String)"values of %s", (Object[])new Object[]{name}));
            return this;
        }

        public UriBuilder replaceQuery(String name, String ... values) {
            return this.replaceQuery(name, Arrays.asList((Object[])Preconditions.checkNotNull((Object)values, (String)"values of %s", (Object[])new Object[]{name})));
        }

        public UriBuilder replaceQuery(Map<String, ?> parameters) {
            return this.replaceQuery((Multimap<String, ?>)Multimaps.forMap(parameters));
        }

        public UriBuilder replaceQuery(Multimap<String, ?> parameters) {
            for (String key : ((Multimap)Preconditions.checkNotNull(parameters, (Object)"parameters")).keySet()) {
                this.replaceQuery(key, parameters.get((Object)key));
            }
            return this;
        }

        private UriBuilder(CharSequence uri) {
            this(URI.create(UriBuilder.escapeSpecialChars((CharSequence)Preconditions.checkNotNull((Object)uri, (Object)"uri"))));
        }

        private static String escapeSpecialChars(CharSequence uri) {
            if (uri.length() < 3) {
                return ((Object)uri).toString();
            }
            StringBuilder builder = new StringBuilder();
            Iterator i$ = Lists.charactersOf((CharSequence)uri).iterator();
            block4: while (i$.hasNext()) {
                char c = ((Character)i$.next()).charValue();
                switch (c) {
                    case '{': {
                        builder.append("((");
                        continue block4;
                    }
                    case '}': {
                        builder.append("))");
                        continue block4;
                    }
                }
                builder.append(c);
            }
            return builder.toString();
        }

        private static String unescapeSpecialChars(CharSequence uri) {
            if (uri.length() < 5) {
                return ((Object)uri).toString();
            }
            char last = uri.charAt(0);
            StringBuilder builder = new StringBuilder();
            Iterator i$ = Lists.charactersOf((CharSequence)uri).iterator();
            while (i$.hasNext()) {
                char c = ((Character)i$.next()).charValue();
                switch (c) {
                    case '(': {
                        if (last == '(') {
                            builder.setCharAt(builder.length() - 1, '{');
                            break;
                        }
                        builder.append('(');
                        break;
                    }
                    case ')': {
                        if (last == ')') {
                            builder.setCharAt(builder.length() - 1, '}');
                            break;
                        }
                        builder.append(')');
                        break;
                    }
                    default: {
                        builder.append(c);
                    }
                }
                last = c;
            }
            return builder.toString();
        }

        private UriBuilder(URI uri) {
            Preconditions.checkNotNull((Object)uri, (Object)"uri");
            this.scheme = uri.getScheme();
            this.host = uri.getHost();
            Integer n = this.port = uri.getPort() == -1 ? null : Integer.valueOf(uri.getPort());
            if (uri.getPath() != null) {
                this.path(UriBuilder.unescapeSpecialChars(uri.getPath()));
            }
            if (uri.getQuery() != null) {
                this.query((Multimap)Queries.queryParser().apply((Object)UriBuilder.unescapeSpecialChars(uri.getQuery())));
            }
        }

        public URI build() {
            return this.build((Map<String, ?>)ImmutableMap.of());
        }

        public URI build(Map<String, ?> variables) {
            try {
                return new URI(this.expand(variables));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public String expand(Map<String, ?> variables) {
            StringBuilder b = new StringBuilder();
            if (this.scheme != null) {
                b.append(this.scheme).append("://");
            }
            if (this.host != null) {
                b.append(UriTemplates.expand(this.host, variables));
            }
            if (this.port != null) {
                b.append(':').append(this.port);
            }
            if (this.path != null) {
                b.append(Strings2.urlEncode(UriTemplates.expand(this.path, variables), this.skipPathEncoding));
            }
            if (this.query.size() > 0) {
                b.append('?').append(Queries.encodeQueryLine(this.query));
            }
            return b.toString();
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            if (this.scheme != null) {
                b.append(this.scheme).append("://");
            }
            if (this.host != null) {
                b.append(this.host);
            }
            if (this.port != null) {
                b.append(':').append(this.port);
            }
            if (this.path != null) {
                b.append(this.path);
            }
            if (this.query.size() > 0) {
                b.append('?').append(Queries.buildQueryLine(this.query));
            }
            return b.toString();
        }
    }
}

