/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.Uris;
import org.jclouds.http.utils.Queries;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.javax.annotation.Nullable;

public class HttpRequest
extends HttpMessage {
    private final String method;
    private final URI endpoint;
    private final List<HttpRequestFilter> filters;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromHttpRequest(this);
    }

    protected HttpRequest(String method, URI endpoint, Multimap<String, String> headers, @Nullable Payload payload, Iterable<HttpRequestFilter> filters) {
        super(headers, payload);
        this.method = (String)Preconditions.checkNotNull((Object)method, (Object)"method");
        this.endpoint = (URI)Preconditions.checkNotNull((Object)endpoint, (Object)"endpoint");
        Preconditions.checkArgument((endpoint.getHost() != null ? 1 : 0) != 0, (Object)String.format("endpoint.getHost() is null for %s", endpoint));
        this.filters = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(filters, (Object)"filters")));
    }

    public String getRequestLine() {
        return String.format("%s %s HTTP/1.1", this.getMethod(), this.getEndpoint().toASCIIString());
    }

    public String getMethod() {
        return this.method;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public List<HttpRequestFilter> getFilters() {
        return this.filters;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.method, this.endpoint, super.hashCode()});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HttpRequest)) {
            return false;
        }
        HttpRequest that = (HttpRequest)HttpRequest.class.cast(obj);
        return super.equals(that) && Objects.equal((Object)this.method, (Object)that.method) && Objects.equal((Object)this.endpoint, (Object)that.endpoint);
    }

    @Override
    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").omitNullValues().add("method", (Object)this.method).add("endpoint", (Object)this.endpoint).add("headers", (Object)this.headers).add("payload", (Object)this.payload);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends HttpMessage.Builder<T> {
        protected String method;
        protected URI endpoint;
        protected ImmutableList.Builder<HttpRequestFilter> filters = ImmutableList.builder();

        public T method(String method) {
            this.method = (String)Preconditions.checkNotNull((Object)method, (Object)"method");
            return (T)((Builder)this.self());
        }

        public T endpoint(URI endpoint) {
            this.endpoint = (URI)Preconditions.checkNotNull((Object)endpoint, (Object)"endpoint");
            return (T)((Builder)this.self());
        }

        public T endpoint(String endpoint) {
            return this.endpoint(URI.create((String)Preconditions.checkNotNull((Object)endpoint, (Object)"endpoint")));
        }

        public T addQueryParam(String name, Iterable<String> values) {
            this.endpoint = Uris.uriBuilder(this.endpoint).addQuery(name, values).build();
            return (T)((Builder)this.self());
        }

        public T addQueryParam(String name, String ... values) {
            this.endpoint = Uris.uriBuilder(this.endpoint).addQuery(name, values).build();
            return (T)((Builder)this.self());
        }

        public T addQueryParams(Multimap<String, String> parameters) {
            this.endpoint = Uris.uriBuilder(this.endpoint).addQuery(parameters).build();
            return (T)((Builder)this.self());
        }

        public T replaceQueryParam(String name, Iterable<String> values) {
            this.endpoint = Uris.uriBuilder(this.endpoint).replaceQuery(name, values).build();
            return (T)((Builder)this.self());
        }

        public T replaceQueryParam(String name, String ... values) {
            this.endpoint = Uris.uriBuilder(this.endpoint).replaceQuery(name, values).build();
            return (T)((Builder)this.self());
        }

        public T replaceQueryParams(Map<String, String> parameters) {
            return this.replaceQueryParams((Multimap<String, String>)Multimaps.forMap(parameters));
        }

        public T replaceQueryParams(Multimap<String, String> parameters) {
            this.endpoint = Uris.uriBuilder(this.endpoint).replaceQuery(parameters).build();
            return (T)((Builder)this.self());
        }

        public T replacePath(String path) {
            Preconditions.checkNotNull((Object)this.endpoint, (Object)"endpoint");
            Preconditions.checkNotNull((Object)path, (Object)"path");
            this.endpoint = Uris.uriBuilder(this.endpoint).path(path).build();
            return (T)((Builder)this.self());
        }

        public T addFormParam(String name, String ... values) {
            return this.addFormParams((Multimap<String, String>)ImmutableMultimap.builder().putAll(Preconditions.checkNotNull((Object)name, (Object)"name"), (Object[])Preconditions.checkNotNull((Object)values, (String)"values of %s", (Object[])new Object[]{name})).build());
        }

        public T addFormParams(Multimap<String, String> parameters) {
            Preconditions.checkNotNull((Object)this.endpoint, (Object)"endpoint");
            LinkedHashMultimap map = this.payload != null ? (Multimap)Queries.queryParser().apply((Object)this.payload.getRawContent().toString()) : LinkedHashMultimap.create();
            map.putAll(parameters);
            this.payload = Payloads.newUrlEncodedFormPayload((Multimap<String, String>)map);
            return (T)((Builder)this.self());
        }

        public T replaceFormParam(String name, String ... values) {
            return this.replaceFormParams((Multimap<String, String>)ImmutableMultimap.builder().putAll(Preconditions.checkNotNull((Object)name, (Object)"name"), (Object[])Preconditions.checkNotNull((Object)values, (String)"values of %s", (Object[])new Object[]{name})).build());
        }

        public T replaceFormParams(Multimap<String, String> parameters) {
            Preconditions.checkNotNull((Object)this.endpoint, (Object)"endpoint");
            LinkedHashMultimap map = this.payload != null ? (Multimap)Queries.queryParser().apply((Object)this.payload.getRawContent().toString()) : LinkedHashMultimap.create();
            for (String key : parameters.keySet()) {
                map.replaceValues((Object)key, (Iterable)parameters.get((Object)key));
            }
            this.payload = Payloads.newUrlEncodedFormPayload((Multimap<String, String>)map);
            return (T)((Builder)this.self());
        }

        public T filters(Iterable<HttpRequestFilter> filters) {
            this.filters = ImmutableList.builder();
            this.filters.addAll((Iterable)Preconditions.checkNotNull(filters, (Object)"filters"));
            return (T)((Builder)this.self());
        }

        public T filter(HttpRequestFilter filter) {
            this.filters.add(Preconditions.checkNotNull((Object)filter, (Object)"filter"));
            return (T)((Builder)this.self());
        }

        @Override
        public HttpRequest build() {
            return new HttpRequest(this.method, this.endpoint, (Multimap<String, String>)this.headers.build(), this.payload, (Iterable<HttpRequestFilter>)this.filters.build());
        }

        public T fromHttpRequest(HttpRequest in) {
            return ((Builder)((Builder)((Builder)super.fromHttpMessage(in)).method(in.getMethod())).endpoint(in.getEndpoint())).filters(in.getFilters());
        }
    }
}

