/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.functions;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;

public class JoinOnK2<K, K2, V>
implements Function<Map<K, Supplier<Set<K2>>>, Map<K2, Supplier<V>>> {
    private final Supplier<Map<K2, Supplier<V>>> regionToEndpointSupplier;

    public JoinOnK2(Supplier<Map<K2, Supplier<V>>> regionToEndpointSupplier) {
        this.regionToEndpointSupplier = regionToEndpointSupplier;
    }

    public Map<K2, Supplier<V>> apply(Map<K, Supplier<Set<K2>>> regionToZones) {
        Map regionToEndpoint = (Map)this.regionToEndpointSupplier.get();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<K, Supplier<Set<K2>>> entry : regionToZones.entrySet()) {
            for (Object zone : (Set)entry.getValue().get()) {
                builder.put(zone, regionToEndpoint.get(entry.getKey()));
            }
        }
        return builder.build();
    }
}

