/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.crypto;

import com.google.common.annotations.Beta;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.io.InputSupplier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Map;
import org.bouncycastle.openssl.PEMWriter;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.crypto.Pems;
import org.jclouds.io.InputSuppliers;
import org.jclouds.util.Strings2;

@Beta
public class SshKeys {
    public static RSAPublicKeySpec publicKeySpecFromOpenSSH(String idRsaPub) {
        try {
            return SshKeys.publicKeySpecFromOpenSSH(InputSuppliers.of(idRsaPub));
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
            return null;
        }
    }

    public static RSAPublicKeySpec publicKeySpecFromOpenSSH(InputSupplier<? extends InputStream> supplier) throws IOException {
        InputStream stream = (InputStream)supplier.getInput();
        Iterable parts = Splitter.on((char)' ').split((CharSequence)Strings2.toStringAndClose(stream));
        Preconditions.checkArgument((Iterables.size((Iterable)parts) >= 2 && "ssh-rsa".equals(Iterables.get((Iterable)parts, (int)0)) ? 1 : 0) != 0, (Object)"bad format, should be: ssh-rsa AAAAB3...");
        stream = new ByteArrayInputStream(CryptoStreams.base64((String)Iterables.get((Iterable)parts, (int)1)));
        String marker = new String(SshKeys.readLengthFirst(stream));
        Preconditions.checkArgument((boolean)"ssh-rsa".equals(marker), (String)"looking for marker ssh-rsa but got %s", (Object[])new Object[]{marker});
        BigInteger publicExponent = new BigInteger(SshKeys.readLengthFirst(stream));
        BigInteger modulus = new BigInteger(SshKeys.readLengthFirst(stream));
        return new RSAPublicKeySpec(modulus, publicExponent);
    }

    static byte[] readLengthFirst(InputStream in) throws IOException {
        int byte1 = in.read();
        int byte2 = in.read();
        int byte3 = in.read();
        int byte4 = in.read();
        int length = (byte1 << 24) + (byte2 << 16) + (byte3 << 8) + (byte4 << 0);
        byte[] val = new byte[length];
        in.read(val, 0, length);
        return val;
    }

    public static KeyPair generateRsaKeyPair(KeyPairGenerator generator, SecureRandom rand) {
        generator.initialize(2048, rand);
        return generator.genKeyPair();
    }

    public static Map<String, String> generate() {
        try {
            return SshKeys.generate(KeyPairGenerator.getInstance("RSA"), new SecureRandom());
        }
        catch (NoSuchAlgorithmException e) {
            Throwables.propagate((Throwable)e);
            return null;
        }
    }

    public static Map<String, String> generate(KeyPairGenerator generator, SecureRandom rand) {
        KeyPair pair = SshKeys.generateRsaKeyPair(generator, rand);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"public", (Object)SshKeys.encodeAsOpenSSH((RSAPublicKey)RSAPublicKey.class.cast(pair.getPublic())));
        builder.put((Object)"private", (Object)SshKeys.encodeAsPem((RSAPrivateKey)RSAPrivateKey.class.cast(pair.getPrivate())));
        return builder.build();
    }

    public static String encodeAsOpenSSH(RSAPublicKey key) {
        byte[] keyBlob = SshKeys.keyBlob(key.getPublicExponent(), key.getModulus());
        return "ssh-rsa " + CryptoStreams.base64(keyBlob);
    }

    public static String encodeAsPem(RSAPrivateKey key) {
        StringWriter stringWriter = new StringWriter();
        PEMWriter pemFormatWriter = new PEMWriter((Writer)stringWriter);
        try {
            pemFormatWriter.writeObject((Object)key);
            pemFormatWriter.close();
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
        return stringWriter.toString();
    }

    public static boolean privateKeyMatchesPublicKey(String privateKeyPEM, String publicKeyOpenSSH) {
        KeySpec privateKeySpec = Pems.privateKeySpec(privateKeyPEM);
        Preconditions.checkArgument((boolean)(privateKeySpec instanceof RSAPrivateCrtKeySpec), (String)"incorrect format expected RSAPrivateCrtKeySpec was %s", (Object[])new Object[]{privateKeySpec});
        return SshKeys.privateKeyMatchesPublicKey((RSAPrivateCrtKeySpec)RSAPrivateCrtKeySpec.class.cast(privateKeySpec), SshKeys.publicKeySpecFromOpenSSH(publicKeyOpenSSH));
    }

    public static boolean privateKeyMatchesPublicKey(RSAPrivateCrtKeySpec privateKey, RSAPublicKeySpec publicKey) {
        return privateKey.getPublicExponent().equals(publicKey.getPublicExponent()) && privateKey.getModulus().equals(publicKey.getModulus());
    }

    public static boolean privateKeyHasFingerprint(RSAPrivateCrtKeySpec privateKey, String fingerprint) {
        return SshKeys.fingerprint(privateKey.getPublicExponent(), privateKey.getModulus()).equals(fingerprint);
    }

    public static boolean privateKeyHasFingerprint(String privateKeyPEM, String fingerprint) {
        KeySpec privateKeySpec = Pems.privateKeySpec(privateKeyPEM);
        Preconditions.checkArgument((boolean)(privateKeySpec instanceof RSAPrivateCrtKeySpec), (String)"incorrect format expected RSAPrivateCrtKeySpec was %s", (Object[])new Object[]{privateKeySpec});
        return SshKeys.privateKeyHasFingerprint((RSAPrivateCrtKeySpec)RSAPrivateCrtKeySpec.class.cast(privateKeySpec), fingerprint);
    }

    public static String fingerprintPrivateKey(String privateKeyPEM) {
        KeySpec privateKeySpec = Pems.privateKeySpec(privateKeyPEM);
        Preconditions.checkArgument((boolean)(privateKeySpec instanceof RSAPrivateCrtKeySpec), (String)"incorrect format expected RSAPrivateCrtKeySpec was %s", (Object[])new Object[]{privateKeySpec});
        RSAPrivateCrtKeySpec certKeySpec = (RSAPrivateCrtKeySpec)RSAPrivateCrtKeySpec.class.cast(privateKeySpec);
        return SshKeys.fingerprint(certKeySpec.getPublicExponent(), certKeySpec.getModulus());
    }

    public static String fingerprintPublicKey(String publicKeyOpenSSH) {
        RSAPublicKeySpec publicKeySpec = SshKeys.publicKeySpecFromOpenSSH(publicKeyOpenSSH);
        return SshKeys.fingerprint(publicKeySpec.getPublicExponent(), publicKeySpec.getModulus());
    }

    public static boolean privateKeyHasSha1(RSAPrivateCrtKeySpec privateKey, String fingerprint) {
        return SshKeys.sha1(privateKey).equals(fingerprint);
    }

    public static boolean privateKeyHasSha1(String privateKeyPEM, String sha1HexColonDelimited) {
        KeySpec privateKeySpec = Pems.privateKeySpec(privateKeyPEM);
        Preconditions.checkArgument((boolean)(privateKeySpec instanceof RSAPrivateCrtKeySpec), (String)"incorrect format expected RSAPrivateCrtKeySpec was %s", (Object[])new Object[]{privateKeySpec});
        return SshKeys.privateKeyHasSha1((RSAPrivateCrtKeySpec)RSAPrivateCrtKeySpec.class.cast(privateKeySpec), sha1HexColonDelimited);
    }

    public static String sha1PrivateKey(String privateKeyPEM) {
        KeySpec privateKeySpec = Pems.privateKeySpec(privateKeyPEM);
        Preconditions.checkArgument((boolean)(privateKeySpec instanceof RSAPrivateCrtKeySpec), (String)"incorrect format expected RSAPrivateCrtKeySpec was %s", (Object[])new Object[]{privateKeySpec});
        RSAPrivateCrtKeySpec certKeySpec = (RSAPrivateCrtKeySpec)RSAPrivateCrtKeySpec.class.cast(privateKeySpec);
        return SshKeys.sha1(certKeySpec);
    }

    public static String sha1(RSAPrivateCrtKeySpec privateKey) {
        try {
            String sha1 = Joiner.on((String)":").join(Splitter.fixedLength((int)2).split((CharSequence)CryptoStreams.hex(CryptoStreams.sha1(KeyFactory.getInstance("RSA").generatePrivate(privateKey).getEncoded()))));
            return sha1;
        }
        catch (InvalidKeySpecException e) {
            Throwables.propagate((Throwable)e);
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            Throwables.propagate((Throwable)e);
            return null;
        }
    }

    public static boolean publicKeyHasFingerprint(RSAPublicKeySpec publicKey, String fingerprint) {
        return SshKeys.fingerprint(publicKey.getPublicExponent(), publicKey.getModulus()).equals(fingerprint);
    }

    public static boolean publicKeyHasFingerprint(String publicKeyOpenSSH, String fingerprint) {
        return SshKeys.publicKeyHasFingerprint(SshKeys.publicKeySpecFromOpenSSH(publicKeyOpenSSH), fingerprint);
    }

    public static String fingerprint(BigInteger publicExponent, BigInteger modulus) {
        byte[] keyBlob = SshKeys.keyBlob(publicExponent, modulus);
        return Joiner.on((String)":").join(Splitter.fixedLength((int)2).split((CharSequence)CryptoStreams.hex(CryptoStreams.md5(keyBlob))));
    }

    public static byte[] keyBlob(BigInteger publicExponent, BigInteger modulus) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            SshKeys.writeLengthFirst("ssh-rsa".getBytes(), out);
            SshKeys.writeLengthFirst(publicExponent.toByteArray(), out);
            SshKeys.writeLengthFirst(modulus.toByteArray(), out);
            return out.toByteArray();
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
            return null;
        }
    }

    static void writeLengthFirst(byte[] array, ByteArrayOutputStream out) throws IOException {
        out.write(array.length >>> 24 & 0xFF);
        out.write(array.length >>> 16 & 0xFF);
        out.write(array.length >>> 8 & 0xFF);
        out.write(array.length >>> 0 & 0xFF);
        if (array.length == 1 && array[0] == 0) {
            out.write(new byte[0]);
        } else {
            out.write(array);
        }
    }
}

