/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.concurrent.config;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jclouds.concurrent.config.DescribedFuture;
import org.jclouds.concurrent.config.ExecutorServiceModule;

public class DescribingExecutorService
implements ExecutorService {
    protected final ExecutorService delegate;

    public DescribingExecutorService(ExecutorService delegate) {
        this.delegate = (ExecutorService)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(tasks, timeout, unit);
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return new DescribedFuture<T>(this.delegate.submit(task), task.toString(), ExecutorServiceModule.getStackTraceHere());
    }

    @Override
    public Future<?> submit(Runnable task) {
        return new DescribedFuture(this.delegate.submit(task), task.toString(), ExecutorServiceModule.getStackTraceHere());
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return new DescribedFuture<T>(this.delegate.submit(task, result), task.toString(), ExecutorServiceModule.getStackTraceHere());
    }

    @Override
    public void execute(Runnable arg0) {
        this.delegate.execute(arg0);
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

