/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.concurrent;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ForwardingObject;
import java.util.concurrent.TimeoutException;
import org.jclouds.util.Throwables2;

public class RetryOnTimeOutExceptionFunction<K, V>
extends ForwardingObject
implements Function<K, V> {
    private final Function<K, V> delegate;

    public RetryOnTimeOutExceptionFunction(Function<K, V> delegate) {
        this.delegate = (Function)Preconditions.checkNotNull(delegate, (Object)"delegate");
    }

    public V apply(K key) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                ex = null;
                return (V)this.delegate().apply(key);
            }
            catch (Exception e) {
                ex = Throwables2.getFirstThrowableOfType(e, TimeoutException.class);
                if (ex != null) continue;
                throw Throwables.propagate((Throwable)e);
            }
        }
        if (ex != null) {
            throw Throwables.propagate(ex);
        }
        assert (false);
        return null;
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    protected Function<K, V> delegate() {
        return this.delegate;
    }
}

