/*
 * Decompiled with CFR 0.152.
 */
package org.nnsoft.guice.rocoto.configuration;

import com.google.inject.AbstractModule;
import com.google.inject.ProvisionException;
import com.google.inject.internal.util.$Preconditions;
import com.google.inject.name.Names;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.nnsoft.guice.rocoto.configuration.PropertiesIterator;
import org.nnsoft.guice.rocoto.configuration.PropertiesURLReader;
import org.nnsoft.guice.rocoto.configuration.binder.PropertyValueBindingBuilder;
import org.nnsoft.guice.rocoto.configuration.binder.XMLPropertiesFormatBindingBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConfigurationModule
extends AbstractModule {
    private static final String ENV_PREFIX = "env.";
    private static final String CLASSPATH_SCHEME = "classpath";
    private List<PropertiesURLReader> readers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void configure() {
        $Preconditions.checkState(this.readers == null, "Re-entry not allowed");
        this.readers = new LinkedList<PropertiesURLReader>();
        this.bindConfigurations();
        try {
            for (PropertiesURLReader reader : this.readers) {
                try {
                    this.bindProperties(reader.readConfiguration());
                }
                catch (Exception e) {
                    this.addError("An error occurred while reading properties from '%s': %s", reader.getUrl(), e.getMessage());
                }
            }
        }
        finally {
            this.readers = null;
        }
    }

    protected abstract void bindConfigurations();

    protected PropertyValueBindingBuilder bindProperty(final String name) {
        $Preconditions.checkNotNull(name, "Property name cannot be null.");
        return new PropertyValueBindingBuilder(){

            public void toValue(String value) {
                $Preconditions.checkNotNull(value, "Null value not admitted for property '%s's", name);
                ConfigurationModule.this.bindConstant().annotatedWith(Names.named(name)).to(value);
            }
        };
    }

    protected void bindProperties(Properties properties) {
        $Preconditions.checkNotNull(properties, "Parameter 'properties' must be not null");
        this.bindProperties(PropertiesIterator.newPropertiesIterator(properties));
    }

    protected void bindProperties(Iterable<Map.Entry<String, String>> properties) {
        $Preconditions.checkNotNull(properties, "Parameter 'properties' must be not null");
        this.bindProperties(properties.iterator());
    }

    protected void bindProperties(Iterator<Map.Entry<String, String>> properties) {
        $Preconditions.checkNotNull(properties, "Parameter 'properties' must be not null");
        while (properties.hasNext()) {
            Map.Entry<String, String> property = properties.next();
            this.bindProperty(property.getKey()).toValue(property.getValue());
        }
    }

    protected void bindSystemProperties() {
        this.bindProperties(System.getProperties());
    }

    protected void bindProperties(Map<String, String> properties) {
        $Preconditions.checkNotNull(properties, "Parameter 'properties' must be not null");
        this.bindProperties(PropertiesIterator.newPropertiesIterator(properties));
    }

    protected void bindEnvironmentVariables() {
        this.bindProperties(PropertiesIterator.newPropertiesIterator(ENV_PREFIX, System.getenv()));
    }

    protected XMLPropertiesFormatBindingBuilder bindProperties(File propertiesResource) {
        $Preconditions.checkNotNull(propertiesResource, "Parameter 'propertiesResource' must be not null");
        return this.bindProperties(propertiesResource.toURI());
    }

    protected XMLPropertiesFormatBindingBuilder bindProperties(URI propertiesResource) {
        $Preconditions.checkNotNull(propertiesResource, "Parameter 'propertiesResource' must be not null");
        if (CLASSPATH_SCHEME.equals(propertiesResource.getScheme())) {
            String path = propertiesResource.getPath();
            if (propertiesResource.getHost() != null) {
                path = propertiesResource.getHost() + path;
            }
            return this.bindProperties(path);
        }
        try {
            return this.bindProperties(propertiesResource.toURL());
        }
        catch (MalformedURLException e) {
            throw new ProvisionException(String.format("URI '%s' not supported: %s", propertiesResource, e.getMessage()));
        }
    }

    protected XMLPropertiesFormatBindingBuilder bindProperties(String classPathResource) {
        return this.bindProperties(classPathResource, this.getClass().getClassLoader());
    }

    protected XMLPropertiesFormatBindingBuilder bindProperties(String classPathResource, ClassLoader classLoader) {
        $Preconditions.checkNotNull(classPathResource, "Parameter 'classPathResource' must be not null");
        $Preconditions.checkNotNull(classLoader, "Parameter 'classLoader' must be not null");
        String resourceURL = classPathResource;
        if ('/' == classPathResource.charAt(0)) {
            resourceURL = classPathResource.substring(1);
        }
        URL url = classLoader.getResource(resourceURL);
        $Preconditions.checkNotNull(url, "ClassPath resource '%s' not found, make sure it is in the ClassPath or you're using the right ClassLoader", classPathResource);
        return this.bindProperties(url);
    }

    protected XMLPropertiesFormatBindingBuilder bindProperties(URL propertiesResource) {
        $Preconditions.checkNotNull(propertiesResource, "parameter 'propertiesResource' must not be null");
        PropertiesURLReader reader = new PropertiesURLReader(propertiesResource);
        this.readers.add(reader);
        return reader;
    }
}

