/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.util;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import com.google.common.io.InputSupplier;
import com.google.common.primitives.Chars;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.util.Patterns;

public class Strings2 {
    public static String urlEncode(String in, char ... skipEncode) {
        return Strings2.urlEncode(in, Chars.asList(skipEncode));
    }

    public static String urlEncode(String in, Iterable<Character> skipEncode) {
        if (Strings2.isUrlEncoded(in)) {
            return in;
        }
        try {
            String returnVal = URLEncoder.encode(in, "UTF-8");
            returnVal = returnVal.replace("+", "%20");
            returnVal = returnVal.replace("*", "%2A");
            for (char c : skipEncode) {
                returnVal = returnVal.replace(Patterns.CHAR_TO_ENCODED.get(Character.valueOf(c)), c + "");
            }
            return returnVal;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Bad encoding on input: " + in, e);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("error creating pattern: " + in, e);
        }
    }

    public static boolean isUrlEncoded(String in) {
        return Patterns.URL_ENCODED_PATTERN.matcher(in).matches();
    }

    public static String urlDecode(@Nullable Object in) {
        if (in == null) {
            return null;
        }
        try {
            return URLDecoder.decode(in.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Bad encoding on input: " + in, e);
        }
    }

    public static String replaceAll(String returnVal, Pattern pattern, String replace) {
        Matcher m = pattern.matcher(returnVal);
        returnVal = m.replaceAll(replace);
        return returnVal;
    }

    public static String replaceAll(String input, char ifMatch, Pattern pattern, String replacement) {
        if (input.indexOf(ifMatch) != -1) {
            input = pattern.matcher(input).replaceAll(replacement);
        }
        return input;
    }

    public static String replaceAll(String input, char match, String replacement) {
        if (input.indexOf(match) != -1) {
            try {
                input = Patterns.CHAR_TO_PATTERN.get(Character.valueOf(match)).matcher(input).replaceAll(replacement);
            }
            catch (ExecutionException e) {
                throw new IllegalStateException("error creating pattern: " + match, e);
            }
        }
        return input;
    }

    public static String toString(InputSupplier<? extends InputStream> supplier) throws IOException {
        return CharStreams.toString(CharStreams.newReaderSupplier(supplier, Charsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toStringAndClose(InputStream input) throws IOException {
        Preconditions.checkNotNull(input, "input");
        try {
            String string = new String(ByteStreams.toByteArray(input), Charsets.UTF_8);
            return string;
        }
        finally {
            Closeables.closeQuietly(input);
        }
    }

    public static InputStream toInputStream(String in) {
        return new ByteArrayInputStream(in.getBytes(Charsets.UTF_8));
    }

    public static String replaceTokens(String input, Map<String, String> replacements) {
        Matcher matcher = Patterns.TOKEN_PATTERN.matcher(input);
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (matcher.find()) {
            String replacement = replacements.get(matcher.group(1));
            builder.append(input.substring(i, matcher.start()));
            if (replacement == null) {
                builder.append(matcher.group(0));
            } else {
                builder.append(replacement);
            }
            i = matcher.end();
        }
        builder.append(input.substring(i, input.length()));
        return builder.toString();
    }

    public static String replaceTokens(String input, Multimap<String, ?> tokenValues) {
        for (Map.Entry<String, ?> tokenValue : tokenValues.entries()) {
            Pattern pattern = Patterns.TOKEN_TO_PATTERN.getUnchecked(tokenValue.getKey());
            input = Strings2.replaceAll(input, pattern, tokenValue.getValue().toString());
        }
        return input;
    }
}

