/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.statements.login;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.crypto.Sha512Crypt;
import org.jclouds.crypto.SshKeys;
import org.jclouds.scriptbuilder.statements.login.AdminAccess;
import org.jclouds.util.PasswordGenerator;

@Singleton
public class DefaultConfiguration
implements AdminAccess.Configuration {
    private final Supplier<String> defaultAdminUsername = Suppliers.ofInstance(System.getProperty("user.name"));
    private final Supplier<Map<String, String>> defaultAdminSshKeys = new Supplier<Map<String, String>>(){

        @Override
        public Map<String, String> get() {
            try {
                return ImmutableMap.of("public", Files.toString(new File(System.getProperty("user.home") + "/.ssh/id_rsa.pub"), Charsets.UTF_8), "private", Files.toString(new File(System.getProperty("user.home") + "/.ssh/id_rsa"), Charsets.UTF_8));
            }
            catch (IOException e) {
                return SshKeys.generate();
            }
        }
    };
    private final Supplier<String> passwordGenerator = PasswordGenerator.INSTANCE;
    private final Function<String, String> cryptFunction = Sha512Crypt.function();

    @Override
    public Supplier<String> defaultAdminUsername() {
        return this.defaultAdminUsername;
    }

    @Override
    public Supplier<Map<String, String>> defaultAdminSshKeys() {
        return this.defaultAdminSshKeys;
    }

    @Override
    public Supplier<String> passwordGenerator() {
        return this.passwordGenerator;
    }

    @Override
    public Function<String, String> cryptFunction() {
        return this.cryptFunction;
    }
}

