/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import org.jclouds.ec2.domain.IpPermission;
import org.jclouds.ec2.domain.IpProtocol;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.SAXException;

public class IpPermissionHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<IpPermission> {
    private StringBuilder currentText = new StringBuilder();
    private IpPermission.Builder builder = IpPermission.builder();
    private String userId;
    private String groupId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IpPermission getResult() {
        try {
            IpPermission ipPermission = this.builder.build();
            return ipPermission;
        }
        finally {
            this.builder = IpPermission.builder();
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) throws SAXException {
        if (SaxUtils.equalsOrSuffix(qName, "ipProtocol")) {
            this.builder.ipProtocol(IpProtocol.fromValue(SaxUtils.currentOrNegative(this.currentText)));
        } else if (SaxUtils.equalsOrSuffix(qName, "fromPort")) {
            this.builder.fromPort(Integer.parseInt(SaxUtils.currentOrNegative(this.currentText)));
        } else if (SaxUtils.equalsOrSuffix(qName, "toPort")) {
            this.builder.toPort(Integer.parseInt(SaxUtils.currentOrNegative(this.currentText)));
        } else if (SaxUtils.equalsOrSuffix(qName, "cidrIp")) {
            this.builder.ipRange(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "userId")) {
            this.userId = SaxUtils.currentOrNull(this.currentText);
        } else if (SaxUtils.equalsOrSuffix(qName, "groupName") || SaxUtils.equalsOrSuffix(qName, "groupId")) {
            this.groupId = SaxUtils.currentOrNull(this.currentText);
        } else if (SaxUtils.equalsOrSuffix(qName, "item")) {
            if (this.userId != null && this.groupId != null) {
                this.builder.userIdGroupPair(this.userId, this.groupId);
            }
            this.groupId = null;
            this.userId = null;
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

