/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.inject.Singleton;
import org.jclouds.crypto.CryptoStreams;

@Singleton
public class ConvertUnencodedBytesToBase64EncodedString
implements Function<Object, String> {
    @Override
    public String apply(Object from) {
        Preconditions.checkArgument(Preconditions.checkNotNull(from, "input") instanceof byte[], "this binder is only valid for byte []!");
        byte[] unencodedData = (byte[])from;
        Preconditions.checkArgument(Preconditions.checkNotNull(unencodedData, "unencodedData").length <= 16384, "userData cannot be larger than 16kb");
        return CryptoStreams.base64(unencodedData);
    }
}

